/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdio;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.stdio.MediaType;
import com.codahale.metrics.Meter;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class AbstractParser
extends AbstractCommand {
    private final Meter numRecordsMeter;
    private Set<MediaType> supportedMimeTypes = null;
    public static final String SUPPORTED_MIME_TYPES = "supportedMimeTypes";

    protected AbstractParser(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
        super(builder, config, parent, child, context);
        List<String> mimeTypes = this.getConfigs().getStringList(config, SUPPORTED_MIME_TYPES, Collections.EMPTY_LIST);
        for (String mimeType : mimeTypes) {
            this.addSupportedMimeType(mimeType);
        }
        this.numRecordsMeter = this.getMeter("numRecords");
    }

    @Deprecated
    protected AbstractParser(Config config, Command parent, Command child, MorphlineContext context) {
        super(config, parent, child, context);
        List<String> mimeTypes = this.getConfigs().getStringList(config, SUPPORTED_MIME_TYPES, Collections.EMPTY_LIST);
        for (String mimeType : mimeTypes) {
            this.addSupportedMimeType(mimeType);
        }
        this.numRecordsMeter = this.getMeter("numRecords");
    }

    protected void addSupportedMimeType(String mediaType) {
        if (this.supportedMimeTypes == null) {
            this.supportedMimeTypes = new HashSet<MediaType>();
        }
        this.supportedMimeTypes.add(this.parseMimeType(mediaType));
    }

    @Override
    protected boolean doProcess(Record record) {
        if (!this.hasAtLeastOneAttachment(record)) {
            return false;
        }
        String streamMediaType = (String)record.getFirstValue("_attachment_mimetype");
        if (!this.isMimeTypeSupported(streamMediaType, record)) {
            return false;
        }
        InputStream stream = this.getAttachmentInputStream(record);
        try {
            boolean bl = this.doProcess(record, stream);
            return bl;
        }
        catch (IOException e) {
            throw new MorphlineRuntimeException(e);
        }
        finally {
            Closeables.closeQuietly((Closeable)stream);
        }
    }

    protected abstract boolean doProcess(Record var1, InputStream var2) throws IOException;

    protected void incrementNumRecords() {
        if (this.isMeasuringMetrics()) {
            this.numRecordsMeter.mark();
        }
    }

    private boolean isMimeTypeSupported(String mediaTypeStr, Record record) {
        if (this.supportedMimeTypes == null) {
            return true;
        }
        if (!this.hasAtLeastOneMimeType(record)) {
            return false;
        }
        MediaType mediaType = this.parseMimeType(mediaTypeStr);
        if (this.supportedMimeTypes.contains(mediaType)) {
            return true;
        }
        for (MediaType rangePattern : this.supportedMimeTypes) {
            if (!this.isMimeTypeMatch(mediaType, rangePattern)) continue;
            return true;
        }
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug("No supported MIME type found for _attachment_mimetype=" + mediaTypeStr);
        }
        return false;
    }

    private MediaType parseMimeType(String mediaTypeStr) {
        MediaType mediaType = MediaType.parse(mediaTypeStr.trim().toLowerCase(Locale.ROOT));
        return mediaType.getBaseType();
    }

    private boolean isMimeTypeMatch(MediaType mediaType, MediaType rangePattern) {
        String WILDCARD = "*";
        String rangePatternType = rangePattern.getType();
        String rangePatternSubtype = rangePattern.getSubtype();
        return !(!rangePatternType.equals(WILDCARD) && !rangePatternType.equals(mediaType.getType()) || !rangePatternSubtype.equals(WILDCARD) && !rangePatternSubtype.equals(mediaType.getSubtype()));
    }

    protected Charset detectCharset(Record record, Charset charset) {
        if (charset != null) {
            return charset;
        }
        List charsets = record.get("_attachment_charset");
        if (charsets.size() == 0) {
            throw new MorphlineRuntimeException("Missing charset for record: " + record);
        }
        String charsetName = (String)charsets.get(0);
        return Charset.forName(charsetName);
    }

    private boolean hasAtLeastOneAttachment(Record record) {
        if (!record.getFields().containsKey((Object)"_attachment_body")) {
            this.LOG.debug("Command failed because of missing attachment for record: {}", (Object)record);
            return false;
        }
        return true;
    }

    private boolean hasAtLeastOneMimeType(Record record) {
        if (!record.getFields().containsKey((Object)"_attachment_mimetype")) {
            this.LOG.debug("Command failed because of missing MIME type for record: {}", (Object)record);
            return false;
        }
        return true;
    }

    private InputStream getAttachmentInputStream(Record record) {
        Object body = record.getFirstValue("_attachment_body");
        Preconditions.checkNotNull((Object)body);
        if (body instanceof byte[]) {
            return new ByteArrayInputStream((byte[])body);
        }
        return (InputStream)body;
    }

    public static void removeAttachments(Record outputRecord) {
        outputRecord.removeAll("_attachment_body");
        outputRecord.removeAll("_attachment_mimetype");
        outputRecord.removeAll("_attachment_charset");
        outputRecord.removeAll("_attachment_name");
    }

    int getBufferSize(InputStream stream) {
        if (stream instanceof ByteArrayInputStream) {
            return 1024;
        }
        return 8192;
    }
}

