/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.scriptengine.java;

import com.cloudera.cdk.morphline.scriptengine.java.FastJavaScriptEngine;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicLong;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptEvaluator<T> {
    private final FastJavaScriptEngine.JavaCompiledScript compiledScript;
    private final String javaCodeBlock;
    private final String parseLocation;
    private static final AtomicLong nextClassNum = new AtomicLong();
    private static final String METHOD_NAME = "eval";
    private static final Logger LOG = LoggerFactory.getLogger(ScriptEvaluator.class);

    public ScriptEvaluator(String javaImports, String javaCodeBlock, Class<T> returnType, String[] parameterNames, Class[] parameterTypes, String parseLocation) throws ScriptException {
        if (parameterNames.length != parameterTypes.length) {
            throw new IllegalArgumentException("Lengths of parameterNames (" + parameterNames.length + ") and parameterTypes (" + parameterTypes.length + ") do not match");
        }
        this.javaCodeBlock = javaCodeBlock;
        this.parseLocation = parseLocation;
        String myPackageName = this.getClass().getName();
        myPackageName = myPackageName.substring(0, myPackageName.lastIndexOf(46));
        String className = "MyJavaClass" + nextClassNum.incrementAndGet();
        String returnTypeName = returnType == Void.class ? "void" : returnType.getCanonicalName();
        String script = "package " + myPackageName + ".scripts;" + "\n" + javaImports + "\n" + "\n public final class " + className + " {" + "\n   public static " + returnTypeName + " " + METHOD_NAME + "(";
        for (int i = 0; i < parameterNames.length; ++i) {
            if (i > 0) {
                script = script + ", ";
            }
            script = script + parameterTypes[i].getCanonicalName() + " " + parameterNames[i];
        }
        script = script + ") { " + javaCodeBlock + " }";
        script = script + "\n }";
        LOG.trace("Compiling script: {}", (Object)script);
        FastJavaScriptEngine engine = new FastJavaScriptEngine();
        StringWriter errorWriter = new StringWriter();
        engine.getContext().setErrorWriter(errorWriter);
        engine.getContext().setAttribute("javax.script.filename", className + ".java", 100);
        ClassLoader[] loaders = this.getClassLoaders();
        engine.getContext().setAttribute("parentLoader", loaders[0], 100);
        try {
            this.compiledScript = (FastJavaScriptEngine.JavaCompiledScript)engine.compile(script, METHOD_NAME, parameterTypes);
        }
        catch (ScriptException e) {
            String errorMsg = errorWriter.toString();
            if (errorMsg.length() > 0) {
                errorMsg = ": " + errorMsg;
            }
            ScriptEvaluator.throwScriptCompilationException(parseLocation, e.getMessage() + errorMsg, null);
            throw null;
        }
        engine.getContext().setErrorWriter(new PrintWriter(System.err, true));
    }

    public T evaluate(Object ... params) throws ScriptException {
        try {
            return (T)this.compiledScript.eval(params);
        }
        catch (ScriptException e) {
            ScriptEvaluator.throwScriptExecutionException(this.parseLocation + " near: '" + this.javaCodeBlock + "'", params, e);
            return null;
        }
    }

    private ClassLoader[] getClassLoaders() {
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader myLoader = this.getClass().getClassLoader();
        if (contextLoader == null) {
            return new ClassLoader[]{myLoader};
        }
        if (contextLoader == myLoader || myLoader == null) {
            return new ClassLoader[]{contextLoader};
        }
        return new ClassLoader[]{contextLoader, myLoader};
    }

    private static void throwScriptCompilationException(String parseLocation, String msg, Throwable t) throws ScriptException {
        if (t == null) {
            throw new ScriptException("Cannot compile script: " + parseLocation + " caused by " + msg);
        }
        ScriptException se = new ScriptException("Cannot compile script: " + parseLocation + " caused by " + msg);
        se.initCause(t);
        throw se;
    }

    private static void throwScriptExecutionException(String parseLocation, Object[] params, Throwable e) throws ScriptException {
        ScriptException se = new ScriptException("Cannot execute script: " + parseLocation + " for params " + Arrays.asList(params).toString());
        se.initCause(e);
        throw se;
    }
}

