/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.base;

import com.cloudera.cdk.morphline.api.ExceptionHandler;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FaultTolerance
implements ExceptionHandler {
    private final boolean isProductionMode;
    private final boolean isIgnoringRecoverableExceptions;
    private final Class[] clazzes;
    public static final String IS_PRODUCTION_MODE = "isProductionMode";
    public static final String IS_IGNORING_RECOVERABLE_EXCEPTIONS = "isIgnoringRecoverableExceptions";
    public static final String RECOVERABLE_EXCEPTION_CLASSES = "recoverableExceptionClasses";
    private static final Logger LOG = LoggerFactory.getLogger(FaultTolerance.class);

    public FaultTolerance(boolean isProductionMode, boolean isIgnoringRecoverableExceptions) {
        this(isProductionMode, isIgnoringRecoverableExceptions, null);
    }

    public FaultTolerance(boolean isProductionMode, boolean isIgnoringRecoverableExceptions, String recoverableExceptionClassNames) {
        this.isProductionMode = isProductionMode;
        this.isIgnoringRecoverableExceptions = isIgnoringRecoverableExceptions;
        this.clazzes = this.parseRecoverableExceptionClassNames(recoverableExceptionClassNames);
    }

    @Override
    public void handleException(Throwable t, Record record) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (this.isProductionMode()) {
            if (!this.isRecoverableException(t)) {
                LOG.warn("Ignoring unrecoverable exception in production mode for record: " + record, t);
                return;
            }
            if (this.isIgnoringRecoverableExceptions()) {
                LOG.warn("Ignoring recoverable exception in production mode for record: " + record, t);
                return;
            }
        }
        throw new MorphlineRuntimeException(t);
    }

    private boolean isProductionMode() {
        return this.isProductionMode;
    }

    private boolean isIgnoringRecoverableExceptions() {
        return this.isIgnoringRecoverableExceptions;
    }

    private boolean isRecoverableException(Throwable t) {
        while (true) {
            for (Class clazz : this.clazzes) {
                if (!clazz.isAssignableFrom(t.getClass())) continue;
                return true;
            }
            Throwable cause = t.getCause();
            if (cause == null || cause == t) {
                return false;
            }
            t = cause;
        }
    }

    private Class[] parseRecoverableExceptionClassNames(String recoverableExceptionClassNames) {
        if (recoverableExceptionClassNames != null && (recoverableExceptionClassNames = recoverableExceptionClassNames.trim()).length() == 0) {
            recoverableExceptionClassNames = null;
        }
        if (recoverableExceptionClassNames == null) {
            return new Class[0];
        }
        String[] classNames = recoverableExceptionClassNames.split(",");
        Class[] classes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            try {
                classes[i] = Class.forName(classNames[i].trim());
                continue;
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }
        return classes;
    }
}

