/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.base;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.Configs;
import com.cloudera.cdk.morphline.base.Connector;
import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCommand
implements Command {
    private final Config config;
    private final Command parent;
    private final Command child;
    private final MorphlineContext context;
    private final String name;
    private final Configs configs;
    private final Meter numProcessCallsMeter;
    private final Meter numNotifyCallsMeter;
    private static final boolean IS_MEASURING_METRICS = "true".equals(System.getProperty("isMeasuringMetrics", "true"));
    protected final Logger LOG = LoggerFactory.getLogger(this.getClass());

    protected AbstractCommand(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
        Preconditions.checkNotNull((Object)builder);
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)child);
        Preconditions.checkNotNull((Object)context);
        this.config = config;
        this.parent = parent;
        this.child = child;
        this.context = context;
        Preconditions.checkArgument((builder.getNames().size() > 0 ? 1 : 0) != 0);
        this.name = "morphline." + builder.getNames().iterator().next();
        this.configs = new Configs();
        this.numProcessCallsMeter = this.getMeter("numProcessCalls");
        this.numNotifyCallsMeter = this.getMeter("numNotifyCalls");
    }

    @Deprecated
    protected AbstractCommand(Config config, Command parent, Command child, MorphlineContext context) {
        Preconditions.checkNotNull((Object)config);
        Preconditions.checkNotNull((Object)parent);
        Preconditions.checkNotNull((Object)child);
        Preconditions.checkNotNull((Object)context);
        this.config = config;
        this.parent = parent;
        this.child = child;
        this.context = context;
        this.name = "morphline." + this.getShortClassName(this.getClass());
        this.configs = new Configs();
        this.numProcessCallsMeter = this.getMeter("numProcessCalls");
        this.numNotifyCallsMeter = this.getMeter("numNotifyCalls");
    }

    @Override
    public Command getParent() {
        return this.parent;
    }

    protected Command getChild() {
        return this.child;
    }

    protected Config getConfig() {
        return this.config;
    }

    protected MorphlineContext getContext() {
        return this.context;
    }

    protected Configs getConfigs() {
        return this.configs;
    }

    @Override
    public final void notify(Record notification) {
        if (this.isMeasuringMetrics()) {
            this.numNotifyCallsMeter.mark();
        }
        this.beforeNotify(notification);
        this.doNotify(notification);
    }

    private void beforeNotify(Record notification) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("beforeNotify: {}", (Object)notification);
        } else {
            this.LOG.debug("beforeNotify()");
        }
    }

    protected void doNotify(Record notification) {
        this.getChild().notify(notification);
    }

    @Override
    public final boolean process(Record record) {
        if (this.isMeasuringMetrics()) {
            this.numProcessCallsMeter.mark();
        }
        this.beforeProcess(record);
        boolean returnValue = this.doProcess(record);
        if (!returnValue) {
            this.LOG.debug("Command failed!");
        }
        return returnValue;
    }

    private void beforeProcess(Record record) {
        if (this.LOG.isTraceEnabled()) {
            this.LOG.trace("beforeProcess: {}", (Object)record);
        } else {
            this.LOG.debug("beforeProcess()");
        }
    }

    protected boolean doProcess(Record record) {
        return this.getChild().process(record);
    }

    protected void validateArguments() {
        this.getConfigs().validateArguments(this.getConfig());
    }

    protected Counter getCounter(String ... names) {
        return this.getContext().getMetricRegistry().counter(this.getMetricName(names));
    }

    protected Histogram getHistogram(String ... names) {
        return this.getContext().getMetricRegistry().histogram(this.getMetricName(names));
    }

    protected Meter getMeter(String ... names) {
        return this.getContext().getMetricRegistry().meter(this.getMetricName(names));
    }

    protected Timer getTimer(String ... names) {
        return this.getContext().getMetricRegistry().timer(this.getMetricName(names));
    }

    private String getMetricName(String ... names) {
        return MetricRegistry.name((String)this.name, (String[])names);
    }

    protected final boolean isMeasuringMetrics() {
        return IS_MEASURING_METRICS;
    }

    private String getShortClassName(Class clazz) {
        String className = clazz.getName();
        int i = className.lastIndexOf(46);
        int j = className.lastIndexOf(36);
        return className.substring(1 + Math.max(i, j));
    }

    protected List<Command> buildCommandChain(Config rootConfig, String configKey, Command finalChild, boolean ignoreNotifications) {
        List<? extends Config> commandConfigs = new Configs().getConfigList(rootConfig, configKey, Collections.EMPTY_LIST);
        ArrayList<Command> commands = new ArrayList<Command>();
        Command currentParent = this;
        Connector lastConnector = null;
        for (int i = 0; i < commandConfigs.size(); ++i) {
            boolean isLast = i == commandConfigs.size() - 1;
            Connector connector = new Connector(ignoreNotifications && isLast);
            if (isLast) {
                connector.setChild(finalChild);
            }
            Config cmdConfig = commandConfigs.get(i);
            Command cmd = this.buildCommand(cmdConfig, currentParent, connector);
            commands.add(cmd);
            if (i > 0) {
                lastConnector.setChild(cmd);
            }
            connector.setParent(cmd);
            currentParent = connector;
            lastConnector = connector;
        }
        return commands;
    }

    protected Command buildCommand(Config cmdConfig, Command currentParent, Command finalChild) {
        CommandBuilder obj;
        Class<CommandBuilder> cmdClass;
        Set entries = cmdConfig.root().unwrapped().entrySet();
        if (entries.size() != 1) {
            throw new MorphlineCompilationException("Illegal number of entries: " + entries.size(), cmdConfig);
        }
        Map.Entry entry = entries.iterator().next();
        String cmdName = (String)entry.getKey();
        this.LOG.trace("Building command: {}", (Object)cmdName);
        if (!cmdName.contains(".") && !cmdName.contains("/")) {
            cmdClass = this.getContext().getCommandBuilder(cmdName);
            if (cmdClass == null) {
                throw new MorphlineCompilationException("No command builder registered for name: " + cmdName, cmdConfig);
            }
        } else {
            String className = cmdName.replace('/', '.');
            try {
                cmdClass = Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new MorphlineCompilationException("Cannot find command class: " + className, cmdConfig, e);
            }
        }
        try {
            obj = cmdClass.newInstance();
        }
        catch (Exception e) {
            throw new MorphlineCompilationException("Cannot instantiate command class: " + cmdClass.getName(), cmdConfig, e);
        }
        if (!(obj instanceof CommandBuilder)) {
            throw new MorphlineCompilationException("Type of command " + cmdName + " must be an instance of " + CommandBuilder.class.getName() + " but is: " + cmdClass.getName(), cmdConfig);
        }
        CommandBuilder builder = obj;
        Command cmd = builder.build(cmdConfig.getConfig(cmdName), currentParent, finalChild, this.getContext());
        return cmd;
    }
}

