/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.List;
import java.util.TreeMap;

public final class Record {
    private ArrayListMultimap<String, Object> fields;

    public Record() {
        this(Record.create());
    }

    private Record(ArrayListMultimap<String, Object> fields) {
        Preconditions.checkNotNull(fields);
        this.fields = fields;
    }

    public Record copy() {
        ArrayListMultimap copy = ArrayListMultimap.create((int)(this.fields.size() + 16), (int)10);
        copy.putAll(this.fields);
        return new Record((ArrayListMultimap<String, Object>)copy);
    }

    public ListMultimap<String, Object> getFields() {
        return this.fields;
    }

    public List get(String key) {
        return this.fields.get((Object)key);
    }

    public void put(String key, Object value) {
        this.fields.put((Object)key, value);
    }

    public Object getFirstValue(String key) {
        List values = this.fields.get((Object)key);
        return values.size() > 0 ? values.get(0) : null;
    }

    public void replaceValues(String key, Object value) {
        List list = this.fields.get((Object)key);
        list.clear();
        list.add(value);
    }

    public void removeAll(String key) {
        this.fields.get((Object)key).clear();
    }

    public void putIfAbsent(String key, Object value) {
        if (!this.fields.containsEntry((Object)key, value)) {
            this.fields.put((Object)key, value);
        }
    }

    public boolean equals(Object other) {
        if (other instanceof Record) {
            return this.fields.equals(((Record)other).getFields());
        }
        return false;
    }

    public int hashCode() {
        return this.fields.hashCode();
    }

    public String toString() {
        return new TreeMap(this.fields.asMap()).toString();
    }

    private static ArrayListMultimap<String, Object> create() {
        return ArrayListMultimap.create();
    }
}

