/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.tika;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import com.typesafe.config.Config;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.DefaultDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesFactory;

public final class DetectMimeTypeBuilder
implements CommandBuilder {
    public Collection<String> getNames() {
        return Collections.singletonList("detectMimeType");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        try {
            return new DetectMimeType(this, config, parent, child, context);
        }
        catch (IOException e) {
            throw new MorphlineCompilationException("Cannot instantiate command", config, (Throwable)e, (CommandBuilder)this);
        }
        catch (MimeTypeException e) {
            throw new MorphlineCompilationException("Cannot instantiate command", config, (Throwable)e, (CommandBuilder)this);
        }
    }

    private static final class DetectMimeType
    extends AbstractCommand {
        private final Detector detector;
        private final boolean preserveExisting;
        private final boolean includeMetaData;
        private final boolean excludeParameters;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DetectMimeType(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) throws IOException, MimeTypeException {
            block8: {
                super(builder, config, parent, child, context);
                this.preserveExisting = this.getConfigs().getBoolean(config, "preserveExisting", true);
                this.includeMetaData = this.getConfigs().getBoolean(config, "includeMetaData", false);
                this.excludeParameters = this.getConfigs().getBoolean(config, "excludeParameters", true);
                ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
                try {
                    if (this.getConfigs().getBoolean(config, "includeDefaultMimeTypes", true)) {
                        String coreFilePath = "tika-mimetypes.xml";
                        String string = MimeTypesFactory.class.getPackage().getName().replace('.', '/') + "/";
                        ClassLoader cl = MimeTypesFactory.class.getClassLoader();
                        URL coreURL = cl.getResource(string + coreFilePath);
                        BufferedInputStream in = new BufferedInputStream(coreURL.openStream());
                        inputStreams.add(in);
                    }
                    for (String string : this.getConfigs().getStringList(config, "mimeTypesFiles", Collections.EMPTY_LIST)) {
                        BufferedInputStream in = new BufferedInputStream(new FileInputStream(new File(string)));
                        inputStreams.add(in);
                    }
                    String mimeTypesString = this.getConfigs().getString(config, "mimeTypesString", null);
                    if (mimeTypesString != null) {
                        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(mimeTypesString.getBytes("UTF-8"));
                        inputStreams.add(byteArrayInputStream);
                    }
                    if (inputStreams.size() > 0) {
                        MimeTypes mimeTypes = MimeTypesFactory.create((InputStream[])inputStreams.toArray(new InputStream[inputStreams.size()]));
                        ServiceLoader loader = new ServiceLoader();
                        this.detector = new DefaultDetector(mimeTypes, loader);
                        break block8;
                    }
                    throw new MorphlineCompilationException("Missing specification for MIME type mappings", config);
                }
                finally {
                    for (InputStream inputStream : inputStreams) {
                        Closeables.closeQuietly((Closeable)inputStream);
                    }
                }
            }
            this.validateArguments();
        }

        protected boolean doProcess(Record record) {
            List attachments;
            if (!(this.preserveExisting && record.getFields().containsKey((Object)"_attachment_mimetype") || (attachments = record.get("_attachment_body")).size() <= 0)) {
                String charset;
                Object attachment = attachments.get(0);
                Preconditions.checkNotNull(attachment);
                InputStream stream = attachment instanceof byte[] ? new ByteArrayInputStream((byte[])attachment) : (InputStream)attachment;
                Metadata metadata = new Metadata();
                String resourceName = (String)record.getFirstValue("_attachment_name");
                if (resourceName != null) {
                    metadata.add("resourceName", resourceName);
                }
                if ((charset = (String)record.getFirstValue("_attachment_charset")) != null) {
                    metadata.add("Content-Encoding", charset);
                }
                if (this.includeMetaData) {
                    for (Map.Entry entry : record.getFields().entries()) {
                        metadata.add((String)entry.getKey(), entry.getValue().toString());
                    }
                }
                String mimeType = this.getMediaType(stream, metadata, this.excludeParameters);
                record.replaceValues("_attachment_mimetype", (Object)mimeType);
            }
            return super.doProcess(record);
        }

        private String getMediaType(InputStream in, Metadata metadata, boolean excludeParameters) {
            int i;
            MediaType mediaType;
            try {
                mediaType = this.getDetector().detect(in, metadata);
            }
            catch (IOException e) {
                throw new MorphlineRuntimeException((Throwable)e);
            }
            String mediaTypeStr = mediaType.toString();
            if (excludeParameters && (i = mediaTypeStr.indexOf(59)) >= 0) {
                mediaTypeStr = mediaTypeStr.substring(0, i);
            }
            return mediaTypeStr;
        }

        protected Detector getDetector() {
            return this.detector;
        }
    }
}

