/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.mp4parser.authoring.tracks;

import com.coremedia.iso.boxes.AbstractMediaHeaderBox;
import com.coremedia.iso.boxes.CompositionTimeToSample;
import com.coremedia.iso.boxes.NullMediaHeaderBox;
import com.coremedia.iso.boxes.SampleDependencyTypeBox;
import com.coremedia.iso.boxes.SampleDescriptionBox;
import com.coremedia.iso.boxes.TimeToSampleBox;
import com.googlecode.mp4parser.authoring.AbstractTrack;
import com.googlecode.mp4parser.authoring.TrackMetaData;
import com.googlecode.mp4parser.boxes.adobe.ActionMessageFormat0SampleEntryBox;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Amf0Track
extends AbstractTrack {
    SortedMap<Long, byte[]> rawSamples = new TreeMap<Long, byte[]>(){};
    private TrackMetaData trackMetaData = new TrackMetaData();

    public Amf0Track(Map<Long, byte[]> rawSamples) {
        this.rawSamples = new TreeMap<Long, byte[]>(rawSamples);
        this.trackMetaData.setCreationTime(new Date());
        this.trackMetaData.setModificationTime(new Date());
        this.trackMetaData.setTimescale(1000L);
        this.trackMetaData.setLanguage("eng");
    }

    @Override
    public List<ByteBuffer> getSamples() {
        LinkedList<ByteBuffer> samples = new LinkedList<ByteBuffer>();
        for (byte[] bytes : this.rawSamples.values()) {
            samples.add(ByteBuffer.wrap(bytes));
        }
        return samples;
    }

    @Override
    public SampleDescriptionBox getSampleDescriptionBox() {
        SampleDescriptionBox stsd = new SampleDescriptionBox();
        ActionMessageFormat0SampleEntryBox amf0 = new ActionMessageFormat0SampleEntryBox();
        amf0.setDataReferenceIndex(1);
        stsd.addBox(amf0);
        return stsd;
    }

    @Override
    public List<TimeToSampleBox.Entry> getDecodingTimeEntries() {
        LinkedList<TimeToSampleBox.Entry> timesToSample = new LinkedList<TimeToSampleBox.Entry>();
        LinkedList keys = new LinkedList(this.rawSamples.keySet());
        Collections.sort(keys);
        long lastTimeStamp = 0L;
        for (Long key : keys) {
            long delta = key - lastTimeStamp;
            if (timesToSample.size() > 0 && timesToSample.peek().getDelta() == delta) {
                timesToSample.peek().setCount(timesToSample.peek().getCount() + 1L);
            } else {
                timesToSample.add(new TimeToSampleBox.Entry(1L, delta));
            }
            lastTimeStamp = key;
        }
        return timesToSample;
    }

    @Override
    public List<CompositionTimeToSample.Entry> getCompositionTimeEntries() {
        return null;
    }

    @Override
    public long[] getSyncSamples() {
        return null;
    }

    @Override
    public List<SampleDependencyTypeBox.Entry> getSampleDependencies() {
        return null;
    }

    @Override
    public TrackMetaData getTrackMetaData() {
        return this.trackMetaData;
    }

    @Override
    public String getHandler() {
        return "data";
    }

    @Override
    public AbstractMediaHeaderBox getMediaHeaderBox() {
        return new NullMediaHeaderBox();
    }
}

