/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.serialization.EventSerializer;
import org.apache.flume.serialization.EventSerializerFactory;
import org.apache.flume.sink.hdfs.AbstractHDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSCompressedDataStream
extends AbstractHDFSWriter {
    private static final Logger logger = LoggerFactory.getLogger(HDFSCompressedDataStream.class);
    private FSDataOutputStream fsOut;
    private CompressionOutputStream cmpOut;
    private boolean isFinished = false;
    private String serializerType;
    private Context serializerContext;
    private EventSerializer serializer;
    private boolean useRawLocalFileSystem;

    @Override
    public void configure(Context context) {
        super.configure(context);
        this.serializerType = context.getString("serializer", "TEXT");
        this.useRawLocalFileSystem = context.getBoolean("hdfs.useRawLocalFileSystem", Boolean.valueOf(false));
        this.serializerContext = new Context((Map)context.getSubProperties("serializer."));
        logger.info("Serializer = " + this.serializerType + ", UseRawLocalFileSystem = " + this.useRawLocalFileSystem);
    }

    @Override
    public void open(String filePath) throws IOException {
        DefaultCodec defCodec = new DefaultCodec();
        SequenceFile.CompressionType cType = SequenceFile.CompressionType.BLOCK;
        this.open(filePath, (CompressionCodec)defCodec, cType);
    }

    @Override
    public void open(String filePath, CompressionCodec codec, SequenceFile.CompressionType cType) throws IOException {
        Configuration conf = new Configuration();
        Path dstPath = new Path(filePath);
        FileSystem hdfs = dstPath.getFileSystem(conf);
        if (this.useRawLocalFileSystem) {
            if (hdfs instanceof LocalFileSystem) {
                hdfs = ((LocalFileSystem)hdfs).getRaw();
            } else {
                logger.warn("useRawLocalFileSystem is set to true but file system is not of type LocalFileSystem: " + hdfs.getClass().getName());
            }
        }
        boolean appending = false;
        if (conf.getBoolean("hdfs.append.support", true) && hdfs.isFile(dstPath)) {
            this.fsOut = hdfs.append(dstPath);
            appending = true;
        } else {
            this.fsOut = hdfs.create(dstPath);
        }
        this.cmpOut = codec.createOutputStream((OutputStream)this.fsOut);
        this.serializer = EventSerializerFactory.getInstance((String)this.serializerType, (Context)this.serializerContext, (OutputStream)this.cmpOut);
        if (appending && !this.serializer.supportsReopen()) {
            this.cmpOut.close();
            this.serializer = null;
            throw new IOException("serializer (" + this.serializerType + ") does not support append");
        }
        this.registerCurrentStream(this.fsOut, hdfs, dstPath);
        if (appending) {
            this.serializer.afterReopen();
        } else {
            this.serializer.afterCreate();
        }
        this.isFinished = false;
    }

    @Override
    public void append(Event e) throws IOException {
        if (this.isFinished) {
            this.cmpOut.resetState();
            this.isFinished = false;
        }
        this.serializer.write(e);
    }

    @Override
    public void sync() throws IOException {
        this.serializer.flush();
        if (!this.isFinished) {
            this.cmpOut.finish();
            this.isFinished = true;
        }
        this.fsOut.flush();
        this.fsOut.sync();
    }

    @Override
    public void close() throws IOException {
        this.serializer.flush();
        this.serializer.beforeClose();
        if (!this.isFinished) {
            this.cmpOut.finish();
            this.isFinished = true;
        }
        this.fsOut.flush();
        this.fsOut.sync();
        this.closeHDFSOutputStream((OutputStream)this.cmpOut);
        this.unregisterCurrentStream();
    }
}

