/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.tools;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flume.FlumeException;
import org.apache.flume.channel.file.CorruptEventException;
import org.apache.flume.channel.file.LogFile;
import org.apache.flume.channel.file.LogFileV3;
import org.apache.flume.channel.file.LogRecord;
import org.apache.flume.channel.file.Serialization;
import org.apache.flume.tools.FlumeTool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileChannelIntegrityTool
implements FlumeTool {
    public static final Logger LOG = LoggerFactory.getLogger(FileChannelIntegrityTool.class);
    private final List<File> dataDirs = new ArrayList<File>();

    @Override
    public void run(String[] args) throws IOException, ParseException {
        boolean shouldContinue = this.parseCommandLineOpts(args);
        if (!shouldContinue) {
            LOG.error("Could not parse command line options. Exiting ...");
            System.exit(1);
        }
        for (File dataDir : this.dataDirs) {
            File[] dataFiles = dataDir.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.endsWith(".meta") && !name.endsWith(".tmp") && !name.endsWith(".meta.old") && !name.equals("in_use.lock");
                }
            });
            if (dataFiles == null || dataFiles.length <= 0) continue;
            for (File dataFile : dataFiles) {
                LOG.info("Checking for corruption in " + dataFile.toString());
                LogFileV3.SequentialReader reader = new LogFileV3.SequentialReader(dataFile, null);
                LogFile.OperationRecordUpdater updater = new LogFile.OperationRecordUpdater(dataFile);
                boolean fileDone = false;
                boolean fileBackedup = false;
                while (!fileDone) {
                    long eventPosition = 0L;
                    try {
                        eventPosition = reader.getPosition();
                        LogRecord record = reader.next();
                        if (record != null) {
                            record.getEvent();
                            continue;
                        }
                        fileDone = true;
                    }
                    catch (CorruptEventException e) {
                        LOG.warn("Corruption found in " + dataFile.toString() + " at " + eventPosition);
                        if (!fileBackedup) {
                            Serialization.copyFile((File)dataFile, (File)new File(dataFile.getParent(), dataFile.getName() + ".bak"));
                            fileBackedup = true;
                        }
                        updater.markRecordAsNoop(eventPosition);
                    }
                }
                updater.close();
                reader.close();
            }
        }
    }

    private boolean parseCommandLineOpts(String[] args) throws ParseException {
        String[] dataDirStr;
        Options options = new Options();
        options.addOption("l", "dataDirs", true, "Comma-separated list of data directories which the tool must verify. This option is mandatory").addOption("h", "help", false, "Display help");
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, args);
        if (commandLine.hasOption("help")) {
            new HelpFormatter().printHelp("java -jar fcintegritytool ", options, true);
            return false;
        }
        if (!commandLine.hasOption("dataDirs")) {
            new HelpFormatter().printHelp("java -jar fcintegritytool ", "", options, "dataDirs is required.", true);
            return false;
        }
        for (String dataDir : dataDirStr = commandLine.getOptionValue("dataDirs").split(",")) {
            File f = new File(dataDir);
            if (!f.exists()) {
                throw new FlumeException("Data directory, " + dataDir + " does not " + "exist.");
            }
            this.dataDirs.add(f);
        }
        return true;
    }
}

