/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.avro;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.stdio.AbstractParser;
import com.typesafe.config.Config;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileReader;
import org.apache.avro.file.SeekableInput;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.DatumReader;

public final class ReadAvroContainerBuilder
implements CommandBuilder {
    public static final String MIME_TYPE = "avro/binary";

    public Collection<String> getNames() {
        return Collections.singletonList("readAvroContainer");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadAvroContainer(config, parent, child, context);
    }

    static final class ForwardOnlySeekableInputStream
    implements SeekableInput {
        private final InputStream in;
        private long pos = 0L;

        public ForwardOnlySeekableInputStream(InputStream in) {
            this.in = in;
        }

        public long tell() throws IOException {
            return this.pos;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            int n = this.in.read(b, off, len);
            if (n > 0) {
                this.pos += (long)n;
            }
            return n;
        }

        public long length() throws IOException {
            throw new UnsupportedOperationException("Random access is not supported");
        }

        public void seek(long p) throws IOException {
            long todo = p - this.pos;
            if (todo < 0L) {
                throw new UnsupportedOperationException("Seeking backwards is not supported");
            }
            this.skip(todo);
        }

        private long skip(long len) throws IOException {
            long todo = len = Math.max(0L, len);
            while (todo > 0L) {
                long ret = this.in.skip(todo);
                if (ret == 0L) {
                    int b = this.in.read();
                    if (b == -1) {
                        throw new EOFException("Premature EOF from inputStream after skipping " + (len - todo) + " byte(s).");
                    }
                    ret = 1L;
                }
                todo -= ret;
                this.pos += ret;
            }
            return len;
        }

        public void close() throws IOException {
            this.in.close();
        }
    }

    static class ReadAvroContainer
    extends AbstractParser {
        protected final Schema readerSchema;

        public ReadAvroContainer(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            String schemaString = this.getConfigs().getString(config, "readerSchemaString", null);
            if (schemaString != null) {
                this.readerSchema = new Schema.Parser().parse(schemaString);
            } else {
                String schemaFile = this.getConfigs().getString(config, "readerSchemaFile", null);
                if (schemaFile != null) {
                    try {
                        this.readerSchema = new Schema.Parser().parse(new File(schemaFile));
                    }
                    catch (IOException e) {
                        throw new MorphlineCompilationException("Cannot parse external Avro reader schema file: " + schemaFile, config, (Throwable)e);
                    }
                } else {
                    this.readerSchema = null;
                }
            }
            if (((Object)((Object)this)).getClass() == ReadAvroContainer.class) {
                this.validateArguments();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean doProcess(Record inputRecord, InputStream in) throws IOException {
            GenericDatumReader datumReader = new GenericDatumReader(null, this.readerSchema);
            DataFileReader reader = null;
            try {
                reader = new DataFileReader((SeekableInput)new ForwardOnlySeekableInputStream(in), (DatumReader)datumReader);
                while (reader.hasNext()) {
                    GenericContainer datum = (GenericContainer)reader.next();
                    if (this.extract(datum, inputRecord)) continue;
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
            return true;
        }

        protected boolean extract(GenericContainer datum, Record inputRecord) {
            this.incrementNumRecords();
            Record outputRecord = inputRecord.copy();
            ReadAvroContainer.removeAttachments((Record)outputRecord);
            outputRecord.put("_attachment_body", (Object)datum);
            outputRecord.put("_attachment_mimetype", (Object)"avro/java+memory");
            return this.getChild().process(outputRecord);
        }
    }
}

