/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.avro;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.avro.ReadAvroContainerBuilder;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericContainer;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;

public final class ReadAvroBuilder
implements CommandBuilder {
    public static final String AVRO_MEMORY_MIME_TYPE = "avro/java+memory";

    public Collection<String> getNames() {
        return Collections.singletonList("readAvro");
    }

    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ReadAvro(config, parent, child, context);
    }

    static final class ReadAvro
    extends ReadAvroContainerBuilder.ReadAvroContainer {
        protected final Schema writerSchema;
        private final boolean isJson;

        public ReadAvro(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            String schemaString = this.getConfigs().getString(config, "writerSchemaString", null);
            if (schemaString != null) {
                this.writerSchema = new Schema.Parser().parse(schemaString);
            } else {
                String schemaFile = this.getConfigs().getString(config, "writerSchemaFile", null);
                if (schemaFile != null) {
                    try {
                        this.writerSchema = new Schema.Parser().parse(new File(schemaFile));
                    }
                    catch (IOException e) {
                        throw new MorphlineCompilationException("Cannot parse external Avro writer schema file: " + schemaFile, config, (Throwable)e);
                    }
                } else {
                    this.writerSchema = null;
                }
            }
            this.isJson = this.getConfigs().getBoolean(config, "isJson", false);
            this.validateArguments();
        }

        protected void validateArguments() {
            super.validateArguments();
            if (this.writerSchema == null) {
                throw new MorphlineCompilationException("You must specify an external Avro writer schema because this is required to read containerless Avro", this.getConfig());
            }
        }

        private boolean isJSON() {
            return this.isJson;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected boolean doProcess(Record inputRecord, InputStream in) throws IOException {
            Preconditions.checkNotNull((Object)this.writerSchema);
            Schema readSchema = this.readerSchema != null ? this.readerSchema : this.writerSchema;
            GenericDatumReader datumReader = new GenericDatumReader(this.writerSchema, readSchema);
            Object decoder = this.isJSON() ? DecoderFactory.get().jsonDecoder(this.writerSchema, in) : DecoderFactory.get().binaryDecoder(in, null);
            try {
                while (true) {
                    GenericContainer datum;
                    if (!this.extract(datum = (GenericContainer)datumReader.read(null, (Decoder)decoder), inputRecord)) {
                        boolean bl = false;
                        return bl;
                    }
                    continue;
                    break;
                }
            }
            catch (EOFException e) {
                return true;
            }
            finally {
                in.close();
            }
        }
    }
}

