/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.solrcell;

import java.util.Collection;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.handler.extraction.SolrContentHandler;
import org.apache.solr.handler.extraction.SolrContentHandlerFactory;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.tika.metadata.Metadata;

public class StripNonCharSolrContentHandlerFactory
extends SolrContentHandlerFactory {
    public StripNonCharSolrContentHandlerFactory(Collection<String> dateFormats) {
        super(dateFormats);
    }

    public SolrContentHandler createSolrContentHandler(Metadata metadata, SolrParams params, IndexSchema schema) {
        return new StripNonCharSolrContentHandler(metadata, params, schema, this.dateFormats);
    }

    private static final class StripNonCharSolrContentHandler
    extends SolrContentHandler {
        public StripNonCharSolrContentHandler(Metadata metadata, SolrParams params, IndexSchema schema, Collection<String> dateFormats) {
            super(metadata, params, schema, dateFormats);
        }

        private static String stripNonCharCodepoints(String input) {
            StringBuilder stripped = new StringBuilder(input.length());
            for (int i = 0; i < input.length(); ++i) {
                char ch = input.charAt(i);
                if (ch % 65536 == 65535 || ch % 65536 == 65534 || ch > '\ufdd0' && ch < '\ufdef' || ch <= '\u001f' && ch != '\t' && ch != '\n' && ch != '\r') continue;
                stripped.append(ch);
            }
            return stripped.toString();
        }

        protected String transformValue(String val, SchemaField schemaField) {
            String ret = super.transformValue(val, schemaField).trim();
            ret = StripNonCharSolrContentHandler.stripNonCharCodepoints(ret);
            return ret;
        }
    }
}

