/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import com.google.common.base.Preconditions;
import org.apache.flume.Context;
import org.apache.flume.sink.hdfs.SequenceFileSerializer;
import org.apache.flume.sink.hdfs.SequenceFileSerializerType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceFileSerializerFactory {
    private static final Logger logger = LoggerFactory.getLogger(SequenceFileSerializerFactory.class);
    static final String CTX_PREFIX = "writeFormat.";

    static SequenceFileSerializer getSerializer(String formatType, Context context) {
        SequenceFileSerializer.Builder builder;
        SequenceFileSerializerType type;
        Preconditions.checkNotNull((Object)formatType, (Object)"serialize type must not be null");
        try {
            type = SequenceFileSerializerType.valueOf(formatType);
        }
        catch (IllegalArgumentException e) {
            logger.debug("Not in enum, loading builder class: {}", (Object)formatType);
            type = SequenceFileSerializerType.Other;
        }
        Class<SequenceFileSerializer.Builder> builderClass = type.getBuilderClass();
        if (builderClass == null) {
            try {
                Class<?> c = Class.forName(formatType);
                if (c == null || !SequenceFileSerializer.Builder.class.isAssignableFrom(c)) {
                    logger.error("Unable to instantiate Builder from {}", (Object)formatType);
                    return null;
                }
                builderClass = c;
            }
            catch (ClassNotFoundException ex) {
                logger.error("Class not found: " + formatType, (Throwable)ex);
                return null;
            }
            catch (ClassCastException ex) {
                logger.error("Class does not extend " + SequenceFileSerializer.Builder.class.getCanonicalName() + ": " + formatType, (Throwable)ex);
                return null;
            }
        }
        try {
            builder = builderClass.newInstance();
        }
        catch (InstantiationException ex) {
            logger.error("Cannot instantiate builder: " + formatType, (Throwable)ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            logger.error("Cannot instantiate builder: " + formatType, (Throwable)ex);
            return null;
        }
        return builder.build(context);
    }
}

