/*
 * Decompiled with CFR 0.152.
 */
package org.restlet.engine.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.TimeUnit;

public class PipeStream {
    private static final long QUEUE_TIMEOUT = 5L;
    private final BlockingQueue<Integer> queue = new ArrayBlockingQueue<Integer>(1024);

    public InputStream getInputStream() {
        return new InputStream(){
            private boolean endReached = false;

            public int read() throws IOException {
                try {
                    if (this.endReached) {
                        return -1;
                    }
                    Integer value = (Integer)PipeStream.this.queue.poll(5L, TimeUnit.SECONDS);
                    boolean bl = this.endReached = value == -1;
                    if (value == null) {
                        throw new IOException("Timeout while reading from the queue-based input stream");
                    }
                    return value;
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interruption occurred while writing in the queue");
                }
            }
        };
    }

    public OutputStream getOutputStream() {
        return new OutputStream(){

            public void write(int b) throws IOException {
                try {
                    if (!PipeStream.this.queue.offer(b & 0xFF, 5L, TimeUnit.SECONDS)) {
                        throw new IOException("Timeout while writing to the queue-based output stream");
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interruption occurred while writing in the queue");
                }
            }

            public void close() throws IOException {
                try {
                    if (!PipeStream.this.queue.offer(-1, 5L, TimeUnit.SECONDS)) {
                        throw new IOException("Timeout while writing to the queue-based output stream");
                    }
                }
                catch (InterruptedException ie) {
                    throw new IOException("Interruption occurred while writing in the queue");
                }
            }
        };
    }
}

