/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.netty.handler.codec.spdy;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

final class SpdySession {
    private final Map<Integer, StreamState> activeStreams = new ConcurrentHashMap<Integer, StreamState>();

    SpdySession() {
    }

    public int numActiveStreams() {
        return this.activeStreams.size();
    }

    public boolean noActiveStreams() {
        return this.activeStreams.isEmpty();
    }

    public boolean isActiveStream(int streamID) {
        return this.activeStreams.containsKey(new Integer(streamID));
    }

    public void acceptStream(int streamID, boolean remoteSideClosed, boolean localSideClosed) {
        if (!remoteSideClosed || !localSideClosed) {
            this.activeStreams.put(new Integer(streamID), new StreamState(remoteSideClosed, localSideClosed));
        }
    }

    public void removeStream(int streamID) {
        this.activeStreams.remove(new Integer(streamID));
    }

    public boolean isRemoteSideClosed(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state == null || state.isRemoteSideClosed();
    }

    public void closeRemoteSide(int streamID) {
        Integer StreamID = new Integer(streamID);
        StreamState state = this.activeStreams.get(StreamID);
        if (state != null) {
            state.closeRemoteSide();
            if (state.isLocalSideClosed()) {
                this.activeStreams.remove(StreamID);
            }
        }
    }

    public boolean isLocalSideClosed(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state == null || state.isLocalSideClosed();
    }

    public void closeLocalSide(int streamID) {
        Integer StreamID = new Integer(streamID);
        StreamState state = this.activeStreams.get(StreamID);
        if (state != null) {
            state.closeLocalSide();
            if (state.isRemoteSideClosed()) {
                this.activeStreams.remove(StreamID);
            }
        }
    }

    public boolean hasReceivedReply(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        return state != null && state.hasReceivedReply();
    }

    public void receivedReply(int streamID) {
        StreamState state = this.activeStreams.get(new Integer(streamID));
        if (state != null) {
            state.receivedReply();
        }
    }

    private static final class StreamState {
        private boolean remoteSideClosed;
        private boolean localSideClosed;
        private boolean receivedReply;

        public StreamState(boolean remoteSideClosed, boolean localSideClosed) {
            this.remoteSideClosed = remoteSideClosed;
            this.localSideClosed = localSideClosed;
        }

        public boolean isRemoteSideClosed() {
            return this.remoteSideClosed;
        }

        public void closeRemoteSide() {
            this.remoteSideClosed = true;
        }

        public boolean isLocalSideClosed() {
            return this.localSideClosed;
        }

        public void closeLocalSide() {
            this.localSideClosed = true;
        }

        public boolean hasReceivedReply() {
            return this.receivedReply;
        }

        public void receivedReply() {
            this.receivedReply = true;
        }
    }
}

