/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.io.UnsupportedEncodingException;
import org.apache.solr.common.SolrException;
import org.apache.solr.rest.GETable;
import org.apache.solr.rest.schema.BaseFieldResource;
import org.apache.solr.rest.schema.BaseSchemaResource;
import org.apache.solr.schema.SchemaField;
import org.restlet.representation.Representation;
import org.restlet.resource.ResourceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FieldResource
extends BaseFieldResource
implements GETable {
    private static final Logger log = LoggerFactory.getLogger(FieldResource.class);
    private boolean includeDynamic;
    private String fieldName;

    @Override
    public void doInit() throws ResourceException {
        super.doInit();
        if (this.isExisting()) {
            this.includeDynamic = this.getSolrRequest().getParams().getBool("includeDynamic", false);
            this.fieldName = (String)this.getRequestAttributes().get("name");
            try {
                this.fieldName = null == this.fieldName ? "" : FieldResource.urlDecode(this.fieldName.trim()).trim();
            }
            catch (UnsupportedEncodingException e) {
                throw new ResourceException((Throwable)e);
            }
        }
    }

    @Override
    public Representation get() {
        try {
            if (this.fieldName.isEmpty()) {
                String message = "Field name is missing";
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Field name is missing");
            }
            SchemaField field = this.includeDynamic ? this.getSchema().getFieldOrNull(this.fieldName) : this.getSchema().getFields().get(this.fieldName);
            if (null == field) {
                String message = "Field '" + this.fieldName + "' not found.";
                throw new SolrException(SolrException.ErrorCode.NOT_FOUND, message);
            }
            this.getSolrResponse().add("field", this.getFieldProperties(field));
        }
        catch (Exception e) {
            this.getSolrResponse().setException(e);
        }
        this.handlePostExecution(log);
        return new BaseSchemaResource.SolrOutputRepresentation();
    }
}

