/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.Slice;

public class AssignShard {
    public static String assignShard(String collection, ClusterState state, Integer numShards) {
        if (numShards == null) {
            numShards = 1;
        }
        String returnShardId = null;
        Map sliceMap = state.getActiveSlicesMap(collection);
        if (sliceMap == null) {
            return "shard1";
        }
        ArrayList shardIdNames = new ArrayList(sliceMap.keySet());
        if (shardIdNames.size() < numShards) {
            return "shard" + (shardIdNames.size() + 1);
        }
        final HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (String shardId : shardIdNames) {
            int cnt = ((Slice)sliceMap.get(shardId)).getReplicasMap().size();
            map.put(shardId, cnt);
        }
        Collections.sort(shardIdNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer one = (Integer)map.get(o1);
                Integer two = (Integer)map.get(o2);
                return one.compareTo(two);
            }
        });
        returnShardId = (String)shardIdNames.get(0);
        return returnShardId;
    }
}

