/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.interceptor;

import java.util.List;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.interceptor.Interceptor;

public class TimestampInterceptor
implements Interceptor {
    private final boolean preserveExisting;

    private TimestampInterceptor(boolean preserveExisting) {
        this.preserveExisting = preserveExisting;
    }

    @Override
    public void initialize() {
    }

    @Override
    public Event intercept(Event event) {
        Map headers = event.getHeaders();
        if (!this.preserveExisting || !headers.containsKey(Constants.TIMESTAMP)) {
            long now = System.currentTimeMillis();
            headers.put(Constants.TIMESTAMP, Long.toString(now));
        }
        return event;
    }

    @Override
    public List<Event> intercept(List<Event> events) {
        for (Event event : events) {
            this.intercept(event);
        }
        return events;
    }

    @Override
    public void close() {
    }

    public static class Constants {
        public static String TIMESTAMP = "timestamp";
        public static String PRESERVE = "preserveExisting";
        public static boolean PRESERVE_DFLT = false;
    }

    public static class Builder
    implements Interceptor.Builder {
        private boolean preserveExisting = Constants.PRESERVE_DFLT;

        @Override
        public Interceptor build() {
            return new TimestampInterceptor(this.preserveExisting);
        }

        @Override
        public void configure(Context context) {
            this.preserveExisting = context.getBoolean(Constants.PRESERVE, Boolean.valueOf(Constants.PRESERVE_DFLT));
        }
    }
}

