/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.MorphlineRuntimeException;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class TryRulesBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("tryRules");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new TryRules(config, parent, child, context);
    }

    private static final class TryRules
    extends AbstractCommand {
        private List<Command> childRules = new ArrayList<Command>();
        private boolean throwExceptionIfAllRulesFailed;
        private boolean catchExceptions;

        public TryRules(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            this.throwExceptionIfAllRulesFailed = this.getConfigs().getBoolean(config, "throwExceptionIfAllRulesFailed", true);
            this.catchExceptions = this.getConfigs().getBoolean(config, "catchExceptions", false);
            List<? extends Config> ruleConfigs = this.getConfigs().getConfigList(config, "rules", Collections.EMPTY_LIST);
            for (Config config2 : ruleConfigs) {
                List<Command> commands = this.buildCommandChain(config2, "commands", child, true);
                if (commands.size() <= 0) continue;
                this.childRules.add(commands.get(0));
            }
            this.validateArguments();
        }

        @Override
        protected void doNotify(Record notification) {
            for (Command childRule : this.childRules) {
                childRule.notify(notification);
            }
            super.doNotify(notification);
        }

        @Override
        protected boolean doProcess(Record record) {
            for (Command childRule : this.childRules) {
                Record copy = record.copy();
                if (!this.catchExceptions) {
                    if (!childRule.process(copy)) continue;
                    return true;
                }
                try {
                    if (!childRule.process(copy)) continue;
                    return true;
                }
                catch (RuntimeException e) {
                    this.LOG.warn("tryRules command caught rule exception. Continuing to try other remaining rules", (Throwable)e);
                }
            }
            this.LOG.warn("tryRules command found no successful rule");
            if (this.throwExceptionIfAllRulesFailed) {
                throw new MorphlineRuntimeException("tryRules command found no successful rule for record: " + record);
            }
            return false;
        }
    }
}

