/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.stdlib;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.CommandBuilder;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.AbstractCommand;
import com.cloudera.cdk.morphline.stdlib.DropRecordBuilder;
import com.typesafe.config.Config;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class IfThenElseBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("if");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new IfThenElse(config, parent, child, context);
    }

    private static final class IfThenElse
    extends AbstractCommand {
        private Command conditionChain;
        private Command thenChain;
        private Command elseChain;

        public IfThenElse(Config config, Command parent, Command child, MorphlineContext context) {
            super(config, parent, child, context);
            List<Command> elseCommands;
            Command devNull = new DropRecordBuilder().build(null, this, null, context);
            List<Command> conditions = this.buildCommandChain(config, "conditions", devNull, true);
            if (conditions.size() == 0) {
                throw new MorphlineCompilationException("Missing conditions", config);
            }
            this.conditionChain = conditions.get(0);
            List<Command> thenCommands = this.buildCommandChain(config, "then", child, true);
            if (thenCommands.size() > 0) {
                this.thenChain = thenCommands.get(0);
            }
            if ((elseCommands = this.buildCommandChain(config, "else", child, true)).size() > 0) {
                this.elseChain = elseCommands.get(0);
            }
            this.validateArguments();
        }

        @Override
        protected List<Command> buildCommandChain(Config rootConfig, String configKey, Command finalChild, boolean ignoreNotifications) {
            this.getConfigs().getConfigList(rootConfig, configKey, null);
            return super.buildCommandChain(rootConfig, configKey, finalChild, ignoreNotifications);
        }

        @Override
        protected void doNotify(Record notification) {
            this.conditionChain.notify(notification);
            if (this.thenChain != null) {
                this.thenChain.notify(notification);
            }
            if (this.elseChain != null) {
                this.elseChain.notify(notification);
            }
            super.doNotify(notification);
        }

        @Override
        protected boolean doProcess(Record record) {
            if (this.conditionChain.process(record)) {
                if (this.thenChain != null) {
                    return this.thenChain.process(record);
                }
            } else if (this.elseChain != null) {
                return this.elseChain.process(record);
            }
            return super.doProcess(record);
        }
    }
}

