/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.reader.internal;

import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.CSVStrategy;
import com.cloudera.cdk.morphline.shaded.com.googlecode.jcsv.reader.CSVTokenizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class CSVTokenizerImpl
implements CSVTokenizer {
    @Override
    public List<String> tokenizeLine(String line, CSVStrategy strategy, BufferedReader reader) throws IOException {
        char DELIMITER = strategy.getDelimiter();
        char QUOTE = strategy.getQuoteCharacter();
        int NEW_LINE = 10;
        StringBuilder sb = new StringBuilder(30);
        ArrayList<String> token = new ArrayList<String>();
        line = line + '\n';
        State state = State.NORMAL;
        int pointer = 0;
        while (true) {
            char c = line.charAt(pointer);
            switch (state) {
                case NORMAL: {
                    if (c == DELIMITER) {
                        token.add(sb.toString());
                        sb.delete(0, sb.length());
                        break;
                    }
                    if (c == '\n') {
                        if (token.size() != 0 || sb.length() != 0) {
                            token.add(sb.toString());
                        }
                        return token;
                    }
                    if (c == QUOTE) {
                        if (sb.length() == 0) {
                            state = State.QUOTED;
                            break;
                        }
                        if (line.charAt(pointer + 1) == QUOTE && sb.length() > 0) {
                            sb.append(c);
                            ++pointer;
                            break;
                        }
                        if (line.charAt(pointer + 1) == QUOTE) break;
                        state = State.QUOTED;
                        break;
                    }
                    sb.append(c);
                    break;
                }
                case QUOTED: {
                    if (c == '\n') {
                        sb.append('\n');
                        pointer = -1;
                        line = reader.readLine();
                        if (line == null) {
                            throw new IllegalStateException("unexpected end of file, unclosed quotation");
                        }
                        line = line + '\n';
                        break;
                    }
                    if (c == QUOTE) {
                        if (line.charAt(pointer + 1) == QUOTE) {
                            sb.append(c);
                            ++pointer;
                            break;
                        }
                        state = State.NORMAL;
                        break;
                    }
                    sb.append(c);
                }
            }
            ++pointer;
        }
    }

    private static enum State {
        NORMAL,
        QUOTED;

    }
}

