/*
 * Decompiled with CFR 0.152.
 */
package com.cloudera.cdk.morphline.base;

import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.typesafe.config.Config;
import java.util.Arrays;

public final class Validator<T> {
    public void validateRange(Config config, T value, Comparable<T> min, Comparable<T> max) {
        boolean isValid;
        boolean bl = isValid = min.compareTo(value) <= 0 && 0 <= max.compareTo(value);
        if (!isValid) {
            this.fail(config, String.format("Invalid choice: '%s' (choose from {%s..%s})", value, min, max));
        }
    }

    public <T extends Enum<T>> T validateEnum(Config config, String value, Class<T> type, T ... choices) {
        if (choices.length == 0) {
            choices = (Enum[])type.getEnumConstants();
        }
        Preconditions.checkArgument((choices.length > 0 ? 1 : 0) != 0);
        try {
            T result = Enum.valueOf(type, value);
            if (!Arrays.asList(choices).contains(result)) {
                throw new IllegalArgumentException();
            }
            return result;
        }
        catch (IllegalArgumentException e) {
            this.fail(config, String.format("Invalid choice: '%s' (choose from {%s})", value, Joiner.on((String)",").join(choices)));
            return null;
        }
    }

    private void fail(Config config, String msg) {
        throw new MorphlineCompilationException(msg, config);
    }
}

