/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.solr.morphline;

import com.cloudera.cdk.morphline.api.Command;
import com.cloudera.cdk.morphline.api.ExceptionHandler;
import com.cloudera.cdk.morphline.api.MorphlineCompilationException;
import com.cloudera.cdk.morphline.api.MorphlineContext;
import com.cloudera.cdk.morphline.api.Record;
import com.cloudera.cdk.morphline.base.Compiler;
import com.cloudera.cdk.morphline.base.FaultTolerance;
import com.cloudera.cdk.morphline.base.Notifications;
import com.codahale.metrics.MetricRegistry;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import java.io.File;
import java.util.Map;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.solr.morphline.MorphlineHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MorphlineHandlerImpl
implements MorphlineHandler {
    private MorphlineContext morphlineContext;
    private Command morphline;
    private Command finalChild;
    private String morphlineFileAndId;
    public static final String MORPHLINE_FILE_PARAM = "morphlineFile";
    public static final String MORPHLINE_ID_PARAM = "morphlineId";
    public static final String MORPHLINE_VARIABLE_PARAM = "morphlineVariable";
    private static final Logger LOG = LoggerFactory.getLogger(MorphlineHandlerImpl.class);

    void setMorphlineContext(MorphlineContext morphlineContext) {
        this.morphlineContext = morphlineContext;
    }

    void setFinalChild(Command finalChild) {
        this.finalChild = finalChild;
    }

    public void configure(Context context) {
        if (this.morphlineContext == null) {
            FaultTolerance faultTolerance = new FaultTolerance(context.getBoolean("isProductionMode", Boolean.valueOf(false)).booleanValue(), context.getBoolean("isIgnoringRecoverableExceptions", Boolean.valueOf(false)).booleanValue(), context.getString("recoverableExceptionClasses"));
            this.morphlineContext = new MorphlineContext.Builder().setExceptionHandler((ExceptionHandler)faultTolerance).setMetricRegistry(new MetricRegistry()).build();
        }
        String morphlineFile = context.getString(MORPHLINE_FILE_PARAM);
        String morphlineId = context.getString(MORPHLINE_ID_PARAM);
        if (morphlineFile == null || morphlineFile.trim().length() == 0) {
            throw new MorphlineCompilationException("Missing parameter: morphlineFile", null);
        }
        Config override = ConfigFactory.parseMap((Map)context.getSubProperties("morphlineVariable."));
        this.morphline = new Compiler().compile(new File(morphlineFile), morphlineId, this.morphlineContext, this.finalChild, new Config[]{override});
        this.morphlineFileAndId = morphlineFile + "@" + morphlineId;
    }

    @Override
    public void process(Event event) {
        Record record = new Record();
        for (Map.Entry entry : event.getHeaders().entrySet()) {
            record.put((String)entry.getKey(), entry.getValue());
        }
        byte[] bytes = event.getBody();
        if (bytes != null && bytes.length > 0) {
            record.put("_attachment_body", (Object)bytes);
        }
        try {
            Notifications.notifyStartSession((Command)this.morphline);
            if (!this.morphline.process(record)) {
                LOG.warn("Morphline {} failed to process record: {}", (Object)this.morphlineFileAndId, (Object)record);
            }
        }
        catch (RuntimeException t) {
            this.morphlineContext.getExceptionHandler().handleException((Throwable)t, record);
        }
    }

    @Override
    public void beginTransaction() {
        Notifications.notifyBeginTransaction((Command)this.morphline);
    }

    @Override
    public void commitTransaction() {
        Notifications.notifyCommitTransaction((Command)this.morphline);
    }

    @Override
    public void rollbackTransaction() {
        Notifications.notifyRollbackTransaction((Command)this.morphline);
    }

    @Override
    public void stop() {
        Notifications.notifyShutdown((Command)this.morphline);
    }
}

