/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.elasticsearch;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.FastDateFormat;
import org.apache.flume.Channel;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.apache.flume.sink.elasticsearch.ElasticSearchEventSerializer;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ElasticSearchSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(ElasticSearchSink.class);
    static final FastDateFormat df = FastDateFormat.getInstance((String)"yyyy-MM-dd");
    private boolean isLocal = false;
    private final CounterGroup counterGroup = new CounterGroup();
    private int batchSize;
    private long ttlMs = -1L;
    private String clusterName = "elasticsearch";
    private String indexName = "flume";
    private String indexType = "log";
    private InetSocketTransportAddress[] serverAddresses;
    private Node node;
    private Client client;
    private ElasticSearchEventSerializer serializer;
    private SinkCounter sinkCounter;

    public ElasticSearchSink() {
        this(false);
    }

    @VisibleForTesting
    ElasticSearchSink(boolean isLocal) {
        this.isLocal = isLocal;
    }

    @VisibleForTesting
    InetSocketTransportAddress[] getServerAddresses() {
        return this.serverAddresses;
    }

    @VisibleForTesting
    String getClusterName() {
        return this.clusterName;
    }

    @VisibleForTesting
    String getIndexName() {
        return this.indexName + "-" + df.format(new Date());
    }

    @VisibleForTesting
    String getIndexType() {
        return this.indexType;
    }

    @VisibleForTesting
    long getTTLMs() {
        return this.ttlMs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status;
        block15: {
            logger.debug("processing...");
            status = Sink.Status.READY;
            Channel channel = this.getChannel();
            Transaction txn = channel.getTransaction();
            try {
                Event event;
                txn.begin();
                String indexName = this.getIndexName();
                BulkRequestBuilder bulkRequest = this.client.prepareBulk();
                for (int i = 0; i < this.batchSize && (event = channel.take()) != null; ++i) {
                    XContentBuilder builder = this.serializer.getContentBuilder(event);
                    IndexRequestBuilder request = this.client.prepareIndex(indexName, this.indexType).setSource(builder);
                    if (this.ttlMs > 0L) {
                        request.setTTL(this.ttlMs);
                    }
                    bulkRequest.add(request);
                }
                int size = bulkRequest.numberOfActions();
                if (size <= 0) {
                    this.sinkCounter.incrementBatchEmptyCount();
                    this.counterGroup.incrementAndGet("channel.underflow");
                    status = Sink.Status.BACKOFF;
                } else {
                    if (size < this.batchSize) {
                        this.sinkCounter.incrementBatchUnderflowCount();
                        status = Sink.Status.BACKOFF;
                    } else {
                        this.sinkCounter.incrementBatchCompleteCount();
                    }
                    this.sinkCounter.addToEventDrainAttemptCount((long)size);
                    BulkResponse bulkResponse = (BulkResponse)bulkRequest.execute().actionGet();
                    if (bulkResponse.hasFailures()) {
                        throw new EventDeliveryException(bulkResponse.buildFailureMessage());
                    }
                }
                txn.commit();
                this.sinkCounter.addToEventDrainSuccessCount((long)size);
                this.counterGroup.incrementAndGet("transaction.success");
            }
            catch (Throwable ex) {
                try {
                    txn.rollback();
                    this.counterGroup.incrementAndGet("transaction.rollback");
                }
                catch (Exception ex2) {
                    logger.error("Exception in rollback. Rollback might not have been successful.", (Throwable)ex2);
                }
                if (ex instanceof Error || ex instanceof RuntimeException) {
                    logger.error("Failed to commit transaction. Transaction rolled back.", ex);
                    Throwables.propagate((Throwable)ex);
                    break block15;
                }
                logger.error("Failed to commit transaction. Transaction rolled back.", ex);
                throw new EventDeliveryException("Failed to commit transaction. Transaction rolled back.", ex);
            }
            finally {
                txn.close();
            }
        }
        return status;
    }

    public void configure(Context context) {
        if (!this.isLocal) {
            String[] hostNames = null;
            if (StringUtils.isNotBlank((String)context.getString("hostNames"))) {
                hostNames = context.getString("hostNames").split(",");
            }
            Preconditions.checkState((hostNames != null && hostNames.length > 0 ? 1 : 0) != 0, (Object)"Missing Param:hostNames");
            this.serverAddresses = new InetSocketTransportAddress[hostNames.length];
            for (int i = 0; i < hostNames.length; ++i) {
                String[] hostPort = hostNames[i].split(":");
                String host = hostPort[0];
                int port = hostPort.length == 2 ? Integer.parseInt(hostPort[1]) : 9300;
                this.serverAddresses[i] = new InetSocketTransportAddress(host, port);
            }
            Preconditions.checkState((this.serverAddresses != null && this.serverAddresses.length > 0 ? 1 : 0) != 0, (Object)"Missing Param:hostNames");
        }
        if (StringUtils.isNotBlank((String)context.getString("indexName"))) {
            this.indexName = context.getString("indexName");
        }
        if (StringUtils.isNotBlank((String)context.getString("indexType"))) {
            this.indexType = context.getString("indexType");
        }
        if (StringUtils.isNotBlank((String)context.getString("clusterName"))) {
            this.clusterName = context.getString("clusterName");
        }
        if (StringUtils.isNotBlank((String)context.getString("batchSize"))) {
            this.batchSize = Integer.parseInt(context.getString("batchSize"));
        }
        if (StringUtils.isNotBlank((String)context.getString("ttl"))) {
            this.ttlMs = TimeUnit.DAYS.toMillis(Integer.parseInt(context.getString("ttl")));
            Preconditions.checkState((this.ttlMs > 0L ? 1 : 0) != 0, (Object)"ttl must be greater than 0 or not set.");
        }
        String serializerClazz = "org.apache.flume.sink.elasticsearch.ElasticSearchLogStashEventSerializer";
        if (StringUtils.isNotBlank((String)context.getString("serializer"))) {
            serializerClazz = context.getString("serializer");
        }
        Context serializerContext = new Context();
        serializerContext.putAll((Map)context.getSubProperties("serializer."));
        try {
            Class<?> clazz = Class.forName(serializerClazz);
            this.serializer = (ElasticSearchEventSerializer)clazz.newInstance();
            this.serializer.configure(serializerContext);
        }
        catch (Exception e) {
            logger.error("Could not instantiate event serializer.", (Throwable)e);
            Throwables.propagate((Throwable)e);
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.indexName), (Object)"Missing Param:indexName");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.indexType), (Object)"Missing Param:indexType");
        Preconditions.checkState((boolean)StringUtils.isNotBlank((String)this.clusterName), (Object)"Missing Param:clusterName");
        Preconditions.checkState((this.batchSize >= 1 ? 1 : 0) != 0, (Object)"batchSize must be greater than 0");
    }

    public void start() {
        logger.info("ElasticSearch sink {} started");
        this.sinkCounter.start();
        try {
            this.openConnection();
        }
        catch (Exception ex) {
            this.sinkCounter.incrementConnectionFailedCount();
            this.closeConnection();
        }
        super.start();
    }

    public void stop() {
        logger.info("ElasticSearch sink {} stopping");
        this.closeConnection();
        this.sinkCounter.stop();
        super.stop();
    }

    private void openConnection() {
        if (this.isLocal) {
            logger.info("Using ElasticSearch AutoDiscovery mode");
            this.openLocalDiscoveryClient();
        } else {
            logger.info("Using ElasticSearch hostnames: {} ", (Object)Arrays.toString(this.serverAddresses));
            this.openClient();
        }
        this.sinkCounter.incrementConnectionCreatedCount();
    }

    private void openLocalDiscoveryClient() {
        this.node = NodeBuilder.nodeBuilder().client(true).local(true).node();
        this.client = this.node.client();
    }

    private void openClient() {
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", this.clusterName).build();
        TransportClient transport = new TransportClient(settings);
        for (InetSocketTransportAddress host : this.serverAddresses) {
            transport.addTransportAddress((TransportAddress)host);
        }
        this.client = transport;
    }

    private void closeConnection() {
        if (this.client != null) {
            this.client.close();
        }
        this.client = null;
        if (this.node != null) {
            this.node.close();
        }
        this.node = null;
        this.sinkCounter.incrementConnectionClosedCount();
    }
}

