/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import com.google.common.base.Charsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.hbase.AsyncHbaseEventSerializer;
import org.apache.flume.sink.hbase.SimpleHbaseEventSerializer;
import org.apache.flume.sink.hbase.SimpleRowKeyGenerator;
import org.hbase.async.AtomicIncrementRequest;
import org.hbase.async.PutRequest;

public class SimpleAsyncHbaseEventSerializer
implements AsyncHbaseEventSerializer {
    private byte[] table;
    private byte[] cf;
    private byte[] payload;
    private byte[] payloadColumn;
    private byte[] incrementColumn;
    private String rowPrefix;
    private byte[] incrementRow;
    private SimpleHbaseEventSerializer.KeyType keyType;

    @Override
    public void initialize(byte[] table, byte[] cf) {
        this.table = table;
        this.cf = cf;
    }

    @Override
    public List<PutRequest> getActions() {
        ArrayList<PutRequest> actions = new ArrayList<PutRequest>();
        if (this.payloadColumn != null) {
            try {
                byte[] rowKey;
                switch (this.keyType) {
                    case TS: {
                        rowKey = SimpleRowKeyGenerator.getTimestampKey(this.rowPrefix);
                        break;
                    }
                    case TSNANO: {
                        rowKey = SimpleRowKeyGenerator.getNanoTimestampKey(this.rowPrefix);
                        break;
                    }
                    case RANDOM: {
                        rowKey = SimpleRowKeyGenerator.getRandomKey(this.rowPrefix);
                        break;
                    }
                    default: {
                        rowKey = SimpleRowKeyGenerator.getUUIDKey(this.rowPrefix);
                    }
                }
                PutRequest putRequest = new PutRequest(this.table, rowKey, this.cf, this.payloadColumn, this.payload);
                actions.add(putRequest);
            }
            catch (Exception e) {
                throw new FlumeException("Could not get row key!", (Throwable)e);
            }
        }
        return actions;
    }

    @Override
    public List<AtomicIncrementRequest> getIncrements() {
        ArrayList<AtomicIncrementRequest> actions = new ArrayList<AtomicIncrementRequest>();
        if (this.incrementColumn != null) {
            AtomicIncrementRequest inc = new AtomicIncrementRequest(this.table, this.incrementRow, this.cf, this.incrementColumn);
            actions.add(inc);
        }
        return actions;
    }

    @Override
    public void cleanUp() {
    }

    public void configure(Context context) {
        String pCol = context.getString("payloadColumn");
        String iCol = context.getString("incrementColumn");
        this.rowPrefix = context.getString("rowPrefix", "default");
        String suffix = context.getString("suffix", "uuid");
        if (pCol != null && !pCol.isEmpty()) {
            this.keyType = suffix.equals("timestamp") ? SimpleHbaseEventSerializer.KeyType.TS : (suffix.equals("random") ? SimpleHbaseEventSerializer.KeyType.RANDOM : (suffix.equals("nano") ? SimpleHbaseEventSerializer.KeyType.TSNANO : SimpleHbaseEventSerializer.KeyType.UUID));
            this.payloadColumn = pCol.getBytes(Charsets.UTF_8);
        }
        if (iCol != null && !iCol.isEmpty()) {
            this.incrementColumn = iCol.getBytes(Charsets.UTF_8);
        }
        this.incrementRow = context.getString("incrementRow", "incRow").getBytes(Charsets.UTF_8);
    }

    @Override
    public void setEvent(Event event) {
        this.payload = event.getBody();
    }

    public void configure(ComponentConfiguration conf) {
    }
}

