/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hbase;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.FlumeException;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.sink.hbase.HbaseEventSerializer;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Row;

public class RegexHbaseEventSerializer
implements HbaseEventSerializer {
    public static final String REGEX_CONFIG = "regex";
    public static final String REGEX_DEFAULT = "(.*)";
    public static final String IGNORE_CASE_CONFIG = "regexIgnoreCase";
    public static final boolean INGORE_CASE_DEFAULT = false;
    public static final String COL_NAME_CONFIG = "colNames";
    public static final String COLUMN_NAME_DEFAULT = "payload";
    protected static final AtomicInteger nonce = new AtomicInteger(0);
    protected static String randomKey = RandomStringUtils.randomAlphanumeric((int)10);
    protected byte[] cf;
    private byte[] payload;
    private List<byte[]> colNames = Lists.newArrayList();
    private boolean regexIgnoreCase;
    private Pattern inputPattern;

    public void configure(Context context) {
        String[] columnNames;
        String regex = context.getString(REGEX_CONFIG, REGEX_DEFAULT);
        this.regexIgnoreCase = context.getBoolean(IGNORE_CASE_CONFIG, Boolean.valueOf(false));
        this.inputPattern = Pattern.compile(regex, 32 + (this.regexIgnoreCase ? 2 : 0));
        String colNameStr = context.getString(COL_NAME_CONFIG, COLUMN_NAME_DEFAULT);
        for (String s : columnNames = colNameStr.split(",")) {
            this.colNames.add(s.getBytes(Charsets.UTF_8));
        }
    }

    public void configure(ComponentConfiguration conf) {
    }

    @Override
    public void initialize(Event event, byte[] columnFamily) {
        this.payload = event.getBody();
        this.cf = columnFamily;
    }

    protected byte[] getRowKey(Calendar cal) {
        String rowKey = String.format("%s-%s-%s", cal.getTimeInMillis(), randomKey, nonce.getAndIncrement());
        return rowKey.getBytes(Charsets.UTF_8);
    }

    protected byte[] getRowKey() {
        return this.getRowKey(Calendar.getInstance());
    }

    @Override
    public List<Row> getActions() throws FlumeException {
        ArrayList actions = Lists.newArrayList();
        Matcher m = this.inputPattern.matcher(new String(this.payload));
        if (!m.matches()) {
            return Lists.newArrayList();
        }
        if (m.groupCount() != this.colNames.size()) {
            return Lists.newArrayList();
        }
        try {
            byte[] rowKey = this.getRowKey();
            Put put = new Put(rowKey);
            for (int i = 0; i < this.colNames.size(); ++i) {
                put.add(this.cf, this.colNames.get(i), m.group(i + 1).getBytes(Charsets.UTF_8));
            }
            actions.add(put);
        }
        catch (Exception e) {
            throw new FlumeException("Could not get row key!", (Throwable)e);
        }
        return actions;
    }

    @Override
    public List<Increment> getIncrements() {
        return Lists.newArrayList();
    }

    @Override
    public void close() {
    }
}

