/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.jboss.netty.buffer.ChannelBuffer;

public final class PutRequest
extends BatchableRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue {
    private static final byte[] PUT = new byte[]{112, 117, 116};
    static final byte CODE = 35;
    static final PutRequest EMPTY_PUT;
    private final byte[] qualifier;
    private final byte[] value;

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp) {
        this(table, key, family, qualifier, value, timestamp, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, RowLock lock) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, RowLock lock) {
        this(table, key, family, qualifier, value, timestamp, lock.id());
    }

    public PutRequest(String table, String key, String family, String qualifier, String value) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, -1L);
    }

    public PutRequest(String table, String key, String family, String qualifier, String value, RowLock lock) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, lock.id());
    }

    public PutRequest(byte[] table, KeyValue kv) {
        this(table, kv, -1L);
    }

    public PutRequest(byte[] table, KeyValue kv, RowLock lock) {
        this(table, kv, lock.id());
    }

    private PutRequest(byte[] table, KeyValue kv, long lockid) {
        super(PUT, table, kv.key(), kv.family(), kv.timestamp(), lockid);
        this.qualifier = kv.qualifier();
        this.value = kv.value();
    }

    private PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, long lockid) {
        super(PUT, table, key, family, timestamp, lockid);
        KeyValue.checkFamily(family);
        KeyValue.checkQualifier(qualifier);
        KeyValue.checkValue(value);
        this.qualifier = qualifier;
        this.value = value;
    }

    public byte[] table() {
        return this.table;
    }

    public byte[] key() {
        return this.key;
    }

    public byte[] qualifier() {
        return this.qualifier;
    }

    public byte[] value() {
        return this.value;
    }

    public String toString() {
        return super.toStringWithQualifier("PutRequest", this.family, this.qualifier, ", value=" + Bytes.pretty(this.value) + ", timestamp=" + this.timestamp + ", lockid=" + this.lockid + ", durable=" + this.durable + ", bufferable=" + this.bufferable);
    }

    byte version(byte server_version) {
        if (server_version >= 29) {
            return 2;
        }
        return 1;
    }

    byte code() {
        return 35;
    }

    int numKeyValues() {
        return 1;
    }

    int payloadSize() {
        return KeyValue.predictSerializedSize(this.key, this.family, this.qualifier, this.value);
    }

    void serializePayload(ChannelBuffer buf) {
        KeyValue.serialize(buf, (byte)4, this.timestamp, this.key, this.family, this.qualifier, this.value);
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 8;
        ++size;
        size += 4;
        ++size;
        size += this.family.length;
        size += 4;
        size += 4;
        return size += this.payloadSize();
    }

    ChannelBuffer serialize(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        PutRequest.writeHBaseByteArray(buf, this.region.name());
        buf.writeByte(35);
        buf.writeByte(35);
        buf.writeByte(1);
        PutRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.lockid);
        buf.writeByte(this.durable ? 1 : 0);
        buf.writeInt(1);
        PutRequest.writeByteArray(buf, this.family);
        buf.writeInt(1);
        buf.writeInt(this.payloadSize());
        this.serializePayload(buf);
        return buf;
    }

    static {
        byte[] zero = new byte[]{0};
        EMPTY_PUT = new PutRequest(zero, zero, zero, zero, zero);
        EMPTY_PUT.setRegion(new RegionInfo(zero, zero, zero));
    }
}

