/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import java.util.Arrays;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseClient;
import org.hbase.async.HBaseRpc;
import org.jboss.netty.buffer.ChannelBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyValue
implements Comparable<KeyValue> {
    public static final long TIMESTAMP_NOW = Long.MAX_VALUE;
    private final byte[] key;
    private final byte[] family;
    private final byte[] qualifier;
    private final byte[] value;
    private final long timestamp;
    static final byte PUT = 4;
    static final byte DELETE_COLUMN = 12;
    static final byte DELETE_FAMILY = 14;

    public KeyValue(byte[] key, byte[] family, byte[] qualifier, long timestamp, byte[] value) {
        KeyValue.checkKey(key);
        KeyValue.checkFamily(family);
        KeyValue.checkQualifier(qualifier);
        KeyValue.checkTimestamp(timestamp);
        KeyValue.checkValue(value);
        this.key = key;
        this.family = family;
        this.qualifier = qualifier;
        this.value = value;
        this.timestamp = timestamp;
    }

    public KeyValue(byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        this(key, family, qualifier, Long.MAX_VALUE, value);
    }

    public byte[] key() {
        return this.key;
    }

    public byte[] family() {
        return this.family;
    }

    public byte[] qualifier() {
        return this.qualifier;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public byte[] value() {
        return this.value;
    }

    @Override
    public int compareTo(KeyValue other) {
        int d = Bytes.memcmp(this.key, other.key);
        if (d != 0) {
            return d;
        }
        d = Bytes.memcmp(this.family, other.family);
        if (d != 0) {
            return d;
        }
        d = Bytes.memcmp(this.qualifier, other.qualifier);
        if (d != 0) {
            return d;
        }
        d = Long.signum(this.timestamp - other.timestamp);
        if (d != 0) {
            return d;
        }
        d = Bytes.memcmp(this.value, other.value);
        return d;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof KeyValue)) {
            return false;
        }
        return this.compareTo((KeyValue)other) == 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.key) ^ Arrays.hashCode(this.family) ^ Arrays.hashCode(this.qualifier) ^ Arrays.hashCode(this.value) ^ (int)(this.timestamp ^ this.timestamp >>> 32);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(84 + this.key.length * 2 + this.family.length + this.qualifier.length + this.value.length);
        buf.append("KeyValue(key=");
        Bytes.pretty(buf, this.key);
        buf.append(", family=");
        Bytes.pretty(buf, this.family);
        buf.append(", qualifier=");
        Bytes.pretty(buf, this.qualifier);
        buf.append(", value=");
        Bytes.pretty(buf, this.value);
        buf.append(", timestamp=").append(this.timestamp);
        buf.append(')');
        return buf.toString();
    }

    public static KeyValue fromBuffer(ChannelBuffer buf, KeyValue prev) {
        int rowkey_length = buf.readInt();
        HBaseRpc.checkNonEmptyArrayLength(buf, rowkey_length);
        int value_length = buf.readInt();
        HBaseRpc.checkArrayLength(buf, value_length);
        short key_length = buf.readShort();
        HBaseRpc.checkArrayLength(buf, value_length);
        byte[] key = new byte[key_length];
        buf.readBytes(key);
        byte family_length = buf.readByte();
        if (key_length + family_length + 2 + 1 + 8 + 1 > rowkey_length) {
            KeyValue.invalid("rowkey_length=" + key_length + " doesn't match key_length + family_length (" + key_length + " + " + family_length + " +12) in " + buf + '=' + Bytes.pretty(buf));
        }
        byte[] family = new byte[family_length];
        buf.readBytes(family);
        int qual_length = rowkey_length - key_length - family_length - 2 - 1 - 8 - 1;
        HBaseRpc.checkArrayLength(buf, qual_length);
        byte[] qualifier = qual_length > 0 ? new byte[qual_length] : HBaseClient.EMPTY_ARRAY;
        buf.readBytes(qualifier);
        long timestamp = buf.readLong();
        byte key_type = buf.readByte();
        byte[] value = value_length > 0 ? new byte[value_length] : HBaseClient.EMPTY_ARRAY;
        buf.readBytes(value);
        if (2 + key_length + 1 + family_length + qual_length + 8 + 1 != rowkey_length) {
            KeyValue.invalid("2 + rl:" + key_length + " + 1 + fl:" + family_length + " + ql:" + qual_length + " + 8 + 1" + " != kl:" + rowkey_length);
        }
        if (prev == null) {
            return new KeyValue(key, family, qualifier, timestamp, value);
        }
        return new KeyValue(Bytes.deDup(prev.key, key), Bytes.deDup(prev.family, family), Bytes.deDup(prev.qualifier, qualifier), timestamp, value);
    }

    private static void invalid(String errmsg) {
        throw new IllegalArgumentException(errmsg);
    }

    static void checkTable(byte[] table) {
        if (table.length > 127) {
            throw new IllegalArgumentException("Table name too long: " + table.length + " bytes long " + Bytes.pretty(table));
        }
        if (table.length == 0) {
            throw new IllegalArgumentException("empty table name");
        }
    }

    static void checkKey(byte[] key) {
        if (key.length > Short.MAX_VALUE) {
            throw new IllegalArgumentException("row key too long: " + key.length + " bytes long " + Bytes.pretty(key));
        }
    }

    static void checkFamily(byte[] family) {
        if (family.length > 127) {
            throw new IllegalArgumentException("column family too long: " + family.length + " bytes long " + Bytes.pretty(family));
        }
    }

    static void checkQualifier(byte[] qualifier) {
        HBaseRpc.checkArrayLength(qualifier);
    }

    static void checkTimestamp(long timestamp) {
        if (timestamp <= 0L) {
            throw new IllegalArgumentException("Negative timestamp: " + timestamp);
        }
    }

    static void checkValue(byte[] value) {
        HBaseRpc.checkArrayLength(value);
    }

    void serialize(ChannelBuffer buf, byte type) {
        KeyValue.serialize(buf, type, this.timestamp, this.key, this.family, this.qualifier, this.value);
    }

    int predictSerializedSize() {
        return KeyValue.predictSerializedSize(this.key, this.family, this.qualifier, this.value);
    }

    static int predictSerializedSize(byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        return 14 + key.length + 1 + family.length + qualifier.length + 8 + 1 + (value == null ? 0 : value.length);
    }

    static void serialize(ChannelBuffer buf, byte type, long timestamp, byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        int val_length = value == null ? 0 : value.length;
        int key_length = 2 + key.length + 1 + family.length + qualifier.length + 8 + 1;
        buf.writeInt(8 + key_length + val_length);
        buf.writeInt(key_length);
        buf.writeInt(val_length);
        buf.writeShort(key.length);
        buf.writeBytes(key);
        buf.writeByte((int)((byte)family.length));
        buf.writeBytes(family);
        buf.writeBytes(qualifier);
        buf.writeLong(timestamp);
        buf.writeByte((int)type);
        if (value != null) {
            buf.writeBytes(value);
        }
    }
}

