/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.jboss.netty.buffer.ChannelBuffer;

public final class AtomicIncrementRequest
extends HBaseRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifier {
    private static final byte[] INCREMENT_COLUMN_VALUE = new byte[]{105, 110, 99, 114, 101, 109, 101, 110, 116, 67, 111, 108, 117, 109, 110, 86, 97, 108, 117, 101};
    private final byte[] family;
    private final byte[] qualifier;
    private long amount;
    private boolean durable = true;

    public AtomicIncrementRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, long amount) {
        super(INCREMENT_COLUMN_VALUE, table, key);
        KeyValue.checkFamily(family);
        KeyValue.checkQualifier(qualifier);
        this.family = family;
        this.qualifier = qualifier;
        this.amount = amount;
    }

    public AtomicIncrementRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier) {
        this(table, key, family, qualifier, 1L);
    }

    public AtomicIncrementRequest(String table, String key, String family, String qualifier, long amount) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), amount);
    }

    public AtomicIncrementRequest(String table, String key, String family, String qualifier) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), 1L);
    }

    public long getAmount() {
        return this.amount;
    }

    public void setAmount(long amount) {
        this.amount = amount;
    }

    public byte[] table() {
        return this.table;
    }

    public byte[] key() {
        return this.key;
    }

    public byte[] family() {
        return this.family;
    }

    public byte[] qualifier() {
        return this.qualifier;
    }

    public String toString() {
        return super.toStringWithQualifier("AtomicIncrementRequest", this.family, this.qualifier, ", amount=" + this.amount);
    }

    void setDurable(boolean durable) {
        this.durable = durable;
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        ++size;
        size += 3;
        size += this.key.length;
        ++size;
        size += this.family.length;
        size += 3;
        size += this.qualifier.length;
        size += 8;
        return ++size;
    }

    ChannelBuffer serialize(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(6);
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.region.name());
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.key);
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.family);
        AtomicIncrementRequest.writeHBaseByteArray(buf, this.qualifier);
        AtomicIncrementRequest.writeHBaseLong(buf, this.amount);
        AtomicIncrementRequest.writeHBaseBool(buf, this.durable);
        return buf;
    }
}

