/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import org.apache.flume.Event;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.LongWritable;

public class HDFSWritableFormatter
implements FlumeFormatter {
    private BytesWritable makeByteWritable(Event e) {
        BytesWritable bytesObject = new BytesWritable();
        bytesObject.set(e.getBody(), 0, e.getBody().length);
        return bytesObject;
    }

    public Class<LongWritable> getKeyClass() {
        return LongWritable.class;
    }

    public Class<BytesWritable> getValueClass() {
        return BytesWritable.class;
    }

    public Object getKey(Event e) {
        String timestamp = (String)e.getHeaders().get("timestamp");
        long eventStamp = timestamp == null ? System.currentTimeMillis() : Long.valueOf(timestamp);
        LongWritable longObject = new LongWritable(eventStamp);
        return longObject;
    }

    public Object getValue(Event e) {
        return this.makeByteWritable(e);
    }

    public byte[] getBytes(Event e) {
        return this.makeByteWritable(e).getBytes();
    }
}

