/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.util.Arrays;
import org.apache.flume.Event;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class HDFSTextFormatter
implements FlumeFormatter {
    private Text makeText(Event e) {
        Text textObject = new Text();
        textObject.set(e.getBody(), 0, e.getBody().length);
        return textObject;
    }

    public Class<LongWritable> getKeyClass() {
        return LongWritable.class;
    }

    public Class<Text> getValueClass() {
        return Text.class;
    }

    public Object getKey(Event e) {
        String timestamp = (String)e.getHeaders().get("timestamp");
        long eventStamp = timestamp == null ? System.currentTimeMillis() : Long.valueOf(timestamp);
        LongWritable longObject = new LongWritable(eventStamp);
        return longObject;
    }

    public Object getValue(Event e) {
        return this.makeText(e);
    }

    public byte[] getBytes(Event e) {
        Text record = this.makeText(e);
        record.append("\n".getBytes(), 0, 1);
        byte[] rawBytes = record.getBytes();
        return Arrays.copyOf(rawBytes, record.getLength());
    }
}

