/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink.hdfs;

import java.io.IOException;
import java.io.OutputStream;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.sink.FlumeFormatter;
import org.apache.flume.sink.hdfs.HDFSWriter;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.SequenceFile;
import org.apache.hadoop.io.compress.CompressionCodec;
import org.apache.hadoop.io.compress.CompressionOutputStream;
import org.apache.hadoop.io.compress.DefaultCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HDFSCompressedDataStream
implements HDFSWriter {
    private static final Logger logger = LoggerFactory.getLogger(HDFSCompressedDataStream.class);
    private FSDataOutputStream fsOut;
    private CompressionOutputStream cmpOut;
    private boolean isFinished = false;

    public void configure(Context context) {
    }

    @Override
    public void open(String filePath, FlumeFormatter fmt) throws IOException {
        DefaultCodec defCodec = new DefaultCodec();
        SequenceFile.CompressionType cType = SequenceFile.CompressionType.BLOCK;
        this.open(filePath, (CompressionCodec)defCodec, cType, fmt);
    }

    @Override
    public void open(String filePath, CompressionCodec codec, SequenceFile.CompressionType cType, FlumeFormatter fmt) throws IOException {
        Configuration conf = new Configuration();
        Path dstPath = new Path(filePath);
        FileSystem hdfs = dstPath.getFileSystem(conf);
        this.fsOut = conf.getBoolean("hdfs.append.support", true) && hdfs.isFile(dstPath) ? hdfs.append(dstPath) : hdfs.create(dstPath);
        this.cmpOut = codec.createOutputStream((OutputStream)this.fsOut);
        this.isFinished = false;
    }

    @Override
    public void append(Event e, FlumeFormatter fmt) throws IOException {
        if (this.isFinished) {
            this.cmpOut.resetState();
            this.isFinished = false;
        }
        byte[] bValue = fmt.getBytes(e);
        this.cmpOut.write(bValue);
    }

    @Override
    public void sync() throws IOException {
        if (!this.isFinished) {
            this.cmpOut.finish();
            this.isFinished = true;
        }
        this.fsOut.flush();
        this.fsOut.sync();
    }

    @Override
    public void close() throws IOException {
        this.sync();
        this.cmpOut.close();
    }
}

