/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.node;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.flume.ChannelFactory;
import org.apache.flume.SinkFactory;
import org.apache.flume.SourceFactory;
import org.apache.flume.channel.DefaultChannelFactory;
import org.apache.flume.conf.properties.PropertiesFileConfigurationProvider;
import org.apache.flume.lifecycle.LifecycleAware;
import org.apache.flume.lifecycle.LifecycleController;
import org.apache.flume.lifecycle.LifecycleException;
import org.apache.flume.lifecycle.LifecycleState;
import org.apache.flume.node.FlumeNode;
import org.apache.flume.node.nodemanager.DefaultLogicalNodeManager;
import org.apache.flume.sink.DefaultSinkFactory;
import org.apache.flume.source.DefaultSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Application {
    private static final Logger logger = LoggerFactory.getLogger(Application.class);
    private String[] args;
    private File configurationFile;
    private String nodeName;
    private SourceFactory sourceFactory = new DefaultSourceFactory();
    private SinkFactory sinkFactory = new DefaultSinkFactory();
    private ChannelFactory channelFactory = new DefaultChannelFactory();

    public static void main(String[] args) {
        Application application = new Application();
        application.setArgs(args);
        try {
            if (application.parseOptions()) {
                application.run();
            }
        }
        catch (ParseException e) {
            logger.error(e.getMessage());
        }
        catch (Exception e) {
            logger.error("A fatal error occurred while running. Exception follows.", (Throwable)e);
        }
    }

    public boolean parseOptions() throws ParseException {
        Options options = new Options();
        Option option = new Option("n", "name", true, "the name of this node");
        options.addOption(option);
        option = new Option("f", "conf-file", true, "specify a conf file");
        options.addOption(option);
        option = new Option("h", "help", false, "display help text");
        options.addOption(option);
        GnuParser parser = new GnuParser();
        CommandLine commandLine = parser.parse(options, this.args);
        if (commandLine.hasOption('f')) {
            this.configurationFile = new File(commandLine.getOptionValue('f'));
            if (!this.configurationFile.exists() && System.getProperty("flume.called.from.service") == null) {
                String path = this.configurationFile.getPath();
                try {
                    path = this.configurationFile.getCanonicalPath();
                }
                catch (IOException ex) {
                    logger.error("Failed to read canonical path for file: " + path, (Throwable)ex);
                }
                throw new ParseException("The specified configuration file does not exist: " + path);
            }
        }
        if (commandLine.hasOption('n')) {
            this.nodeName = commandLine.getOptionValue('n');
        }
        if (commandLine.hasOption('h')) {
            new HelpFormatter().printHelp("flume-ng node", options, true);
            return false;
        }
        return true;
    }

    public void run() throws LifecycleException, InterruptedException, InstantiationException {
        final FlumeNode node = new FlumeNode();
        DefaultLogicalNodeManager nodeManager = new DefaultLogicalNodeManager();
        PropertiesFileConfigurationProvider configurationProvider = new PropertiesFileConfigurationProvider();
        configurationProvider.setChannelFactory(this.channelFactory);
        configurationProvider.setSourceFactory(this.sourceFactory);
        configurationProvider.setSinkFactory(this.sinkFactory);
        configurationProvider.setNodeName(this.nodeName);
        configurationProvider.setConfigurationAware(nodeManager);
        configurationProvider.setFile(this.configurationFile);
        Preconditions.checkState((this.configurationFile != null ? 1 : 0) != 0, (Object)"Configuration file not specified");
        Preconditions.checkState((this.nodeName != null ? 1 : 0) != 0, (Object)"Node name not specified");
        node.setName(this.nodeName);
        node.setNodeManager(nodeManager);
        node.setConfigurationProvider(configurationProvider);
        Runtime.getRuntime().addShutdownHook(new Thread("node-shutdownHook"){

            @Override
            public void run() {
                node.stop();
            }
        });
        node.start();
        LifecycleController.waitForOneOf((LifecycleAware)node, (LifecycleState[])LifecycleState.START_OR_ERROR);
        LifecycleController.waitForOneOf((LifecycleAware)node, (LifecycleState[])LifecycleState.STOP_OR_ERROR);
    }

    public String[] getArgs() {
        return this.args;
    }

    public void setArgs(String[] args) {
        this.args = args;
    }
}

