/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.recoverable.memory.wal;

import com.google.common.collect.Lists;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.channel.recoverable.memory.wal.WALEntry;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.ReflectionUtils;

class WALDataFile<T extends Writable> {
    private static final int VERSION = 1;
    private static final int RECORD_TYPE_EVENT = 1;
    private static final int RECORD_TYPE_COMMIT = 2;

    WALDataFile() {
    }

    private static <T extends Writable> WALEntry<T> newWALEntry(Class<T> clazz, Configuration conf) {
        return new WALEntry<Writable>((Writable)ReflectionUtils.newInstance(clazz, (Configuration)conf));
    }

    static class Writer<T extends Writable>
    implements Closeable {
        private FileOutputStream fileOutput;
        private DataOutputStream dataOutput;
        private AtomicLong largestSequenceID = new AtomicLong(0L);
        private File path;

        Writer(File path) throws IOException {
            this.path = path;
            this.fileOutput = new FileOutputStream(path);
            this.dataOutput = new DataOutputStream(this.fileOutput);
            this.dataOutput.writeInt(1);
            this.flush();
        }

        synchronized void append(List<WALEntry<T>> entries) throws IOException {
            for (WALEntry<T> entry : entries) {
                this.largestSequenceID.set(Math.max(entry.getSequenceID(), this.largestSequenceID.get()));
                this.dataOutput.writeInt(1);
                entry.write(this.dataOutput);
            }
            this.dataOutput.writeInt(2);
            this.flush(false);
        }

        synchronized void flush() throws IOException {
            this.flush(true);
        }

        synchronized void flush(boolean metadata) throws IOException {
            this.fileOutput.getChannel().force(metadata);
        }

        public long getLargestSequenceID() {
            return this.largestSequenceID.get();
        }

        public File getPath() {
            return this.path;
        }

        public long getSize() {
            return this.dataOutput.size();
        }

        @Override
        public synchronized void close() throws IOException {
            if (this.dataOutput != null) {
                this.flush();
                this.dataOutput.close();
            }
        }
    }

    static class Reader<T extends Writable>
    implements Closeable {
        Class<T> clazz;
        DataInputStream input;
        private Configuration conf = new Configuration();

        Reader(File path, Class<T> clazz) throws IOException {
            this.clazz = clazz;
            this.input = new DataInputStream(new FileInputStream(path));
            int version = this.input.readInt();
            if (version != 1) {
                throw new IOException("Expected 1 and got " + version);
            }
        }

        List<WALEntry<T>> nextBatch() throws IOException {
            ArrayList batch = Lists.newArrayList();
            try {
                int type;
                while ((type = this.input.readInt()) == 1) {
                    WALEntry entry = WALDataFile.newWALEntry(this.clazz, this.conf);
                    entry.readFields(this.input);
                    batch.add(entry);
                }
                if (type == 2) {
                    return batch;
                }
                throw new IOException("Unknown record type " + Integer.toHexString(type));
            }
            catch (EOFException e) {
                return null;
            }
        }

        @Override
        public void close() throws IOException {
            if (this.input != null) {
                this.input.close();
            }
        }
    }
}

