/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.recoverable.memory.wal;

import com.google.common.base.Charsets;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.flume.channel.recoverable.memory.wal.SequenceIDBuffer;
import org.apache.flume.channel.recoverable.memory.wal.WALDataFile;
import org.apache.flume.channel.recoverable.memory.wal.WALEntry;
import org.apache.flume.channel.recoverable.memory.wal.WALReplayResult;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WAL<T extends Writable>
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(WAL.class);
    private File path;
    private File dataPath;
    private File sequenceIDPath;
    private Class<T> clazz;
    private WALDataFile.Writer<T> dataFileWALWriter;
    private WALDataFile.Writer<NullWritable> sequenceIDWALWriter;
    private Map<String, Long> fileLargestSequenceIDMap = Collections.synchronizedMap(new HashMap());
    private AtomicLong largestCommitedSequenceID = new AtomicLong(0L);
    private volatile boolean rollRequired;
    private volatile boolean rollInProgress;
    private volatile long rollSize;
    private volatile long maxLogsSize;
    private volatile long minLogRetentionPeriod;
    private volatile long workerInterval;
    private int numReplaySequenceIDOverride;
    private Worker backgroundWorker;
    public static final long DEFAULT_ROLL_SIZE = 0x4000000L;
    public static final long DEFAULT_MAX_LOGS_SIZE = 0x20000000L;
    public static final long DEFAULT_MIN_LOG_RETENTION_PERIOD = 300000L;
    public static final long DEFAULT_WORKER_INTERVAL = 60000L;

    WAL(File path, Class<T> clazz) throws IOException {
        this(path, clazz, 0x4000000L, 0x20000000L, 300000L, 60000L);
    }

    public WAL(File path, Class<T> clazz, long rollSize, long maxLogsSize, long minLogRentionPeriod, long workerInterval) throws IOException {
        this.path = path;
        this.rollSize = rollSize;
        this.maxLogsSize = maxLogsSize;
        this.minLogRetentionPeriod = minLogRentionPeriod;
        this.workerInterval = workerInterval;
        StringBuffer buffer = new StringBuffer();
        buffer.append("path = ").append(path).append(", ");
        buffer.append("rollSize = ").append(rollSize).append(", ");
        buffer.append("maxLogsSize = ").append(maxLogsSize).append(", ");
        buffer.append("minLogRentionPeriod = ").append(minLogRentionPeriod).append(", ");
        buffer.append("workerInterval = ").append(workerInterval);
        LOG.info("WAL Parameters: " + buffer);
        File clazzNamePath = new File(path, "clazz");
        this.createOrDie(path);
        if (clazzNamePath.exists()) {
            String clazzName = Files.readFirstLine((File)clazzNamePath, (Charset)Charsets.UTF_8);
            if (!clazzName.equals(clazz.getName())) {
                throw new IOException("WAL is for " + clazzName + " and you are passing " + clazz.getName());
            }
        } else {
            Files.write((byte[])clazz.getName().getBytes(Charsets.UTF_8), (File)clazzNamePath);
        }
        this.dataPath = new File(path, "data");
        this.sequenceIDPath = new File(path, "seq");
        this.createOrDie(this.dataPath);
        this.createOrDie(this.sequenceIDPath);
        this.clazz = clazz;
        this.backgroundWorker = new Worker(this);
        this.backgroundWorker.setName("WAL-Worker-" + path.getAbsolutePath());
        this.backgroundWorker.setDaemon(true);
        this.backgroundWorker.start();
        this.roll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void roll() throws IOException {
        try {
            this.rollInProgress = true;
            LOG.info("Rolling WAL " + this.path);
            if (this.dataFileWALWriter != null) {
                this.fileLargestSequenceIDMap.put(this.dataFileWALWriter.getPath().getAbsolutePath(), this.dataFileWALWriter.getLargestSequenceID());
                this.dataFileWALWriter.close();
            }
            if (this.sequenceIDWALWriter != null) {
                this.fileLargestSequenceIDMap.put(this.sequenceIDWALWriter.getPath().getAbsolutePath(), this.sequenceIDWALWriter.getLargestSequenceID());
                this.sequenceIDWALWriter.close();
            }
            long ts = System.currentTimeMillis();
            File dataWalFileName = new File(this.dataPath, Long.toString(ts));
            File seqWalFileName = new File(this.sequenceIDPath, Long.toString(ts));
            while (dataWalFileName.exists() || seqWalFileName.exists()) {
                dataWalFileName = new File(this.dataPath, Long.toString(++ts));
                seqWalFileName = new File(this.sequenceIDPath, Long.toString(ts));
            }
            this.dataFileWALWriter = new WALDataFile.Writer(dataWalFileName);
            this.sequenceIDWALWriter = new WALDataFile.Writer(seqWalFileName);
            this.rollRequired = false;
        }
        finally {
            this.rollInProgress = false;
            WAL wAL = this;
            synchronized (wAL) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WALReplayResult<T> replay() throws IOException {
        final AtomicLong sequenceID = new AtomicLong(0L);
        final HashMap fileLargestSequenceIDMap = Maps.newHashMap();
        final AtomicLong totalBytes = new AtomicLong(0L);
        this.readFiles(this.sequenceIDPath, new Function<File, Void>(){

            public Void apply(File input) {
                totalBytes.addAndGet(input.length());
                return null;
            }
        });
        int baseSize = WALEntry.getBaseSize();
        int numEntries = Math.max((int)((float)(totalBytes.get() / (long)baseSize) * 1.05f) + 1, this.numReplaySequenceIDOverride);
        LOG.info("Replay assumptions: baseSize = " + baseSize + ", estimatedNumEntries " + numEntries);
        final SequenceIDBuffer sequenceIDs = new SequenceIDBuffer(numEntries);
        final AtomicInteger index = new AtomicInteger(0);
        this.readFiles(this.sequenceIDPath, new Function<File, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void apply(File input) {
                LOG.info("Replaying " + input);
                WALDataFile.Reader<NullWritable> reader = null;
                int localIndex = index.get();
                try {
                    List<WALEntry<NullWritable>> batch;
                    reader = new WALDataFile.Reader<NullWritable>(input, NullWritable.class);
                    long largestForFile = Long.MIN_VALUE;
                    while ((batch = reader.nextBatch()) != null) {
                        for (WALEntry<NullWritable> entry : batch) {
                            long current = entry.getSequenceID();
                            sequenceIDs.put(localIndex++, current);
                            largestForFile = Math.max(largestForFile, current);
                        }
                    }
                    sequenceID.set(Math.max(largestForFile, sequenceID.get()));
                    fileLargestSequenceIDMap.put(input.getAbsolutePath(), largestForFile);
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
                finally {
                    index.set(localIndex);
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException e) {}
                    }
                }
                return null;
            }
        });
        sequenceIDs.sort();
        final ArrayList entries = Lists.newArrayList();
        final Class<T> dataClazz = this.clazz;
        this.readFiles(this.dataPath, new Function<File, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void apply(File input) {
                LOG.info("Replaying " + input);
                WALDataFile.Reader reader = null;
                try {
                    reader = new WALDataFile.Reader(input, dataClazz);
                    List<Object> batch = Lists.newArrayList();
                    long largestForFile = Long.MIN_VALUE;
                    while ((batch = reader.nextBatch()) != null) {
                        for (WALEntry wALEntry : batch) {
                            long current = wALEntry.getSequenceID();
                            if (!sequenceIDs.exists(current)) {
                                entries.add(wALEntry);
                            }
                            largestForFile = Math.max(largestForFile, current);
                        }
                    }
                    sequenceID.set(Math.max(largestForFile, sequenceID.get()));
                    fileLargestSequenceIDMap.put(input.getAbsolutePath(), largestForFile);
                }
                catch (IOException e) {
                    Throwables.propagate((Throwable)e);
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                return null;
            }
        });
        sequenceIDs.close();
        Map<String, Long> map = this.fileLargestSequenceIDMap;
        synchronized (map) {
            this.fileLargestSequenceIDMap.clear();
            this.fileLargestSequenceIDMap.putAll(fileLargestSequenceIDMap);
            LOG.info("SequenceIDMap " + fileLargestSequenceIDMap);
        }
        this.largestCommitedSequenceID.set(sequenceID.get());
        LOG.info("Replay complete: LargestCommitedSequenceID = " + this.largestCommitedSequenceID.get());
        return new WALReplayResult(entries, this.largestCommitedSequenceID.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeEntries(List<WALEntry<T>> entries) throws IOException {
        Preconditions.checkNotNull(this.dataFileWALWriter, (Object)"Write is null, close must have been called");
        WAL wAL = this;
        synchronized (wAL) {
            if (this.isRollRequired()) {
                this.roll();
            }
        }
        this.waitWhileRolling();
        boolean error = true;
        try {
            this.dataFileWALWriter.append(entries);
            error = false;
        }
        finally {
            if (error) {
                this.rollRequired = true;
            }
        }
    }

    public void writeEntry(WALEntry<T> entry) throws IOException {
        ArrayList entries = Lists.newArrayList();
        entries.add(entry);
        this.writeEntries(entries);
    }

    public void writeSequenceID(long sequenceID) throws IOException {
        ArrayList sequenceIDs = Lists.newArrayList();
        sequenceIDs.add(sequenceID);
        this.writeSequenceIDs(sequenceIDs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeSequenceIDs(List<Long> sequenceIDs) throws IOException {
        Preconditions.checkNotNull(this.sequenceIDWALWriter, (Object)"Write is null, close must have been called");
        WAL wAL = this;
        synchronized (wAL) {
            if (this.isRollRequired()) {
                this.roll();
            }
        }
        this.waitWhileRolling();
        boolean error = true;
        try {
            ArrayList entries = Lists.newArrayList();
            for (Long sequenceID : sequenceIDs) {
                this.largestCommitedSequenceID.set(Math.max(sequenceID, this.largestCommitedSequenceID.get()));
                entries.add(new WALEntry<NullWritable>(NullWritable.get(), sequenceID));
                this.sequenceIDWALWriter.append(entries);
            }
            error = false;
        }
        finally {
            if (error) {
                this.rollRequired = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitWhileRolling() {
        WAL wAL = this;
        synchronized (wAL) {
            while (this.rollInProgress) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.backgroundWorker != null) {
            this.backgroundWorker.shutdown();
        }
        if (this.sequenceIDWALWriter != null) {
            this.sequenceIDWALWriter.close();
            this.sequenceIDWALWriter = null;
        }
        if (this.dataFileWALWriter != null) {
            this.dataFileWALWriter.close();
            this.dataFileWALWriter = null;
        }
    }

    private boolean isRollRequired() throws IOException {
        if (this.rollRequired) {
            return true;
        }
        return Math.max(this.dataFileWALWriter.getSize(), this.sequenceIDWALWriter.getSize()) > this.rollSize;
    }

    private void readFiles(File path, Function<File, Void> function) throws IOException {
        File[] dataFiles = path.listFiles();
        ArrayList files = Lists.newArrayList();
        if (dataFiles != null) {
            for (File dataFile : dataFiles) {
                if (!dataFile.isFile()) {
                    throw new IOException("Not file " + dataFile);
                }
                files.add(dataFile);
            }
        }
        for (File dataFile : files) {
            function.apply((Object)dataFile);
        }
    }

    private void createOrDie(File path) throws IOException {
        if (!path.isDirectory() && !path.mkdirs()) {
            throw new IOException("Unable to create " + path);
        }
    }

    public void setRollSize(long rollSize) {
        this.rollSize = rollSize;
    }

    public void setMaxLogsSize(long maxLogsSize) {
        this.maxLogsSize = maxLogsSize;
    }

    public void setMinLogRetentionPeriod(long minLogRetentionPeriod) {
        this.minLogRetentionPeriod = minLogRetentionPeriod;
    }

    public void setWorkerInterval(long workerInterval) {
        this.workerInterval = workerInterval;
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        Preconditions.checkPositionIndex((int)0, (int)args.length, (String)"input directory is a required arg");
        Preconditions.checkPositionIndex((int)1, (int)args.length, (String)"output directory is a required arg");
        Preconditions.checkPositionIndex((int)2, (int)args.length, (String)"classname is a required arg");
        String input = args[0];
        String output = args[1];
        Class<?> clazz = Class.forName(args[2].trim());
        WAL inputWAL = new WAL(new File(input), clazz);
        if (args.length == 4) {
            inputWAL.numReplaySequenceIDOverride = Integer.parseInt(args[3]);
            System.out.println("Overridng numReplaySequenceIDOverride: " + inputWAL.numReplaySequenceIDOverride);
        }
        WALReplayResult<?> result = inputWAL.replay();
        inputWAL.close();
        System.out.println("     SeqID: " + result.getSequenceID());
        System.out.println("NumEntries: " + result.getResults().size());
        WAL outputWAL = new WAL(new File(output), clazz);
        outputWAL.writeEntries(result.getResults());
        outputWAL.close();
    }

    private static class Worker
    extends Thread {
        private WAL<? extends Writable> wal;
        private volatile boolean run = true;

        public Worker(WAL<? extends Writable> wal) {
            this.wal = wal;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LOG.info("Background worker reporting for duty");
            while (this.run) {
                try {
                    try {
                        Thread.sleep(((WAL)this.wal).workerInterval);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    if (!this.run) continue;
                    ArrayList filesToRemove = Lists.newArrayList();
                    long totalSize = 0L;
                    Map map = ((WAL)this.wal).fileLargestSequenceIDMap;
                    synchronized (map) {
                        File file;
                        for (String key : ((WAL)this.wal).fileLargestSequenceIDMap.keySet()) {
                            file = new File(key);
                            totalSize += file.length();
                        }
                        if (totalSize >= ((WAL)this.wal).maxLogsSize) {
                            for (String key : ((WAL)this.wal).fileLargestSequenceIDMap.keySet()) {
                                file = new File(key);
                                Long seqid = (Long)((WAL)this.wal).fileLargestSequenceIDMap.get(key);
                                long largestCommitedSeqID = ((WAL)this.wal).largestCommitedSequenceID.get();
                                if (!file.exists() || System.currentTimeMillis() - file.lastModified() <= ((WAL)this.wal).minLogRetentionPeriod || largestCommitedSeqID <= seqid) continue;
                                filesToRemove.add(key);
                                LOG.info("Removing expired file " + key + ", seqid = " + seqid + ", result = " + file.delete());
                            }
                            for (String key : filesToRemove) {
                                ((WAL)this.wal).fileLargestSequenceIDMap.remove(key);
                            }
                        }
                    }
                }
                catch (Exception ex) {
                    LOG.error("Uncaught exception in background worker", (Throwable)ex);
                }
            }
            LOG.warn(this.getClass().getSimpleName() + " moving on due to stop request");
        }

        public void shutdown() {
            this.run = false;
            this.interrupt();
        }
    }
}

