/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source.http;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.source.AbstractSource;
import org.apache.flume.source.http.HTTPBadRequestException;
import org.apache.flume.source.http.HTTPSourceHandler;
import org.mortbay.jetty.HandlerContainer;
import org.mortbay.jetty.Server;
import org.mortbay.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTPSource.class);
    private volatile Integer port;
    private volatile Server srv;
    private HTTPSourceHandler handler;

    @Override
    public void configure(Context context) {
        try {
            this.port = context.getInteger("port");
            this.checkPort();
            String handlerClassName = context.getString("handler", "org.apache.flume.source.http.JSONHandler");
            Class<?> clazz = Class.forName(handlerClassName);
            this.handler = (HTTPSourceHandler)clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            ImmutableMap subProps = context.getSubProperties("handler.");
            this.handler.configure(new Context((Map)subProps));
        }
        catch (ClassNotFoundException ex) {
            LOG.error("Error while configuring HTTPSource. Exception follows.", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        catch (ClassCastException ex) {
            LOG.error("Deserializer is not an instance of HTTPSourceHandler.Deserializer must implement HTTPSourceHandler.");
            Throwables.propagate((Throwable)ex);
        }
        catch (Exception ex) {
            LOG.error("Error configuring HTTPSource!", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
    }

    @Override
    public void start() {
        this.checkPort();
        Preconditions.checkState((this.srv == null ? 1 : 0) != 0, (Object)("Running HTTP Server found in source: " + this.getName() + " before I started one." + "Will not attempt to start."));
        this.srv = new Server(this.port.intValue());
        try {
            org.mortbay.jetty.servlet.Context root = new org.mortbay.jetty.servlet.Context((HandlerContainer)this.srv, "/", 1);
            root.addServlet(new ServletHolder((Servlet)new FlumeHTTPServlet()), "/");
            this.srv.start();
            Preconditions.checkArgument((boolean)this.srv.getHandler().equals(root));
        }
        catch (Exception ex) {
            LOG.error("Error while starting HTTPSource. Exception follows.", (Throwable)ex);
            Throwables.propagate((Throwable)ex);
        }
        Preconditions.checkArgument((boolean)this.srv.isRunning());
        super.start();
    }

    @Override
    public void stop() {
        try {
            this.srv.stop();
            this.srv.join();
            this.srv = null;
        }
        catch (Exception ex) {
            LOG.error("Error while stopping HTTPSource. Exception follows.", (Throwable)ex);
        }
    }

    private void checkPort() {
        Preconditions.checkNotNull((Object)this.port, (Object)"HTTPSource requires a port number to bespecified");
    }

    private class FlumeHTTPServlet
    extends HttpServlet {
        private static final long serialVersionUID = 4891924863218790344L;

        private FlumeHTTPServlet() {
        }

        public void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
            ArrayList<Event> events = new ArrayList(0);
            try {
                events = HTTPSource.this.handler.getEvents(request);
            }
            catch (HTTPBadRequestException ex) {
                LOG.warn("Received bad request from client. ", (Throwable)((Object)ex));
                response.sendError(400, "Bad request from client. " + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                LOG.warn("Deserializer threw unexpected exception. ", (Throwable)ex);
                response.sendError(500, "Deserializer threw unexpected exception. " + ex.getMessage());
                return;
            }
            try {
                HTTPSource.this.getChannelProcessor().processEventBatch(events);
            }
            catch (ChannelException ex) {
                LOG.warn("Error appending event to channel. Channel might be full. Consider increasing the channelcapacity or make sure the sinks perform faster.", (Throwable)ex);
                response.sendError(503, "Error appending event to channel. Channel might be full." + ex.getMessage());
                return;
            }
            catch (Exception ex) {
                LOG.warn("Unexpected error appending event to channel. ", (Throwable)ex);
                response.sendError(500, "Unexpected error while appending event to channel. " + ex.getMessage());
                return;
            }
            response.setCharacterEncoding(request.getCharacterEncoding());
            response.setStatus(200);
            response.flushBuffer();
        }

        public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
            this.doPost(request, response);
        }
    }
}

