/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.client.avro.SpoolingFileLineReader;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SpoolDirectorySource
extends AbstractSource
implements Configurable,
EventDrivenSource {
    private static final Logger logger = LoggerFactory.getLogger(SpoolDirectorySource.class);
    private static int POLL_DELAY_MS = 500;
    private String completedSuffix;
    private String spoolDirectory;
    private boolean fileHeader;
    private String fileHeaderKey;
    private int batchSize;
    private int bufferMaxLines;
    private int bufferMaxLineLength;
    private ScheduledExecutorService executor;
    private CounterGroup counterGroup;
    private Runnable runner;
    SpoolingFileLineReader reader;

    @Override
    public void start() {
        logger.info("SpoolDirectorySource source starting with directory:{}", (Object)this.spoolDirectory);
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.counterGroup = new CounterGroup();
        File directory = new File(this.spoolDirectory);
        this.reader = new SpoolingFileLineReader(directory, this.completedSuffix, this.bufferMaxLines, this.bufferMaxLineLength);
        this.runner = new SpoolDirectoryRunnable(this.reader, this.counterGroup);
        this.executor.scheduleWithFixedDelay(this.runner, 0L, POLL_DELAY_MS, TimeUnit.MILLISECONDS);
        super.start();
        logger.debug("SpoolDirectorySource source started");
    }

    @Override
    public void stop() {
        super.stop();
    }

    @Override
    public void configure(Context context) {
        this.spoolDirectory = context.getString("spoolDir");
        Preconditions.checkState((this.spoolDirectory != null ? 1 : 0) != 0, (Object)"Configuration must specify a spooling directory");
        this.completedSuffix = context.getString("fileSuffix", ".COMPLETED");
        this.fileHeader = context.getBoolean("fileHeader", Boolean.valueOf(false));
        this.fileHeaderKey = context.getString("fileHeaderKey", "file");
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(10));
        this.bufferMaxLines = context.getInteger("bufferMaxLines", Integer.valueOf(100));
        this.bufferMaxLineLength = context.getInteger("bufferMaxLineLength", Integer.valueOf(5000));
    }

    private Event createEvent(String lineEntry, String filename) {
        Event out = EventBuilder.withBody((byte[])lineEntry.getBytes());
        if (this.fileHeader) {
            out.getHeaders().put(this.fileHeaderKey, filename);
        }
        return out;
    }

    private class SpoolDirectoryRunnable
    implements Runnable {
        private SpoolingFileLineReader reader;
        private CounterGroup counterGroup;

        public SpoolDirectoryRunnable(SpoolingFileLineReader reader, CounterGroup counterGroup) {
            this.reader = reader;
            this.counterGroup = counterGroup;
        }

        @Override
        public void run() {
            block4: {
                try {
                    List<String> strings;
                    while ((strings = this.reader.readLines(SpoolDirectorySource.this.batchSize)).size() != 0) {
                        String file = this.reader.getLastFileRead();
                        ArrayList events = Lists.newArrayList();
                        for (String s : strings) {
                            this.counterGroup.incrementAndGet("spooler.lines.read");
                            events.add(SpoolDirectorySource.this.createEvent(s, file));
                        }
                        SpoolDirectorySource.this.getChannelProcessor().processEventBatch(events);
                        this.reader.commit();
                    }
                }
                catch (Throwable t) {
                    logger.error("Uncaught exception in Runnable", t);
                    if (!(t instanceof Error)) break block4;
                    throw (Error)t;
                }
            }
        }
    }
}

