/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import java.util.ArrayList;
import java.util.List;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.PollableSource;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SequenceGeneratorSource
extends AbstractSource
implements PollableSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(SequenceGeneratorSource.class);
    private long sequence = 0L;
    private int batchSize;
    private CounterGroup counterGroup = new CounterGroup();
    private List<Event> batchArrayList;

    @Override
    public void configure(Context context) {
        this.batchSize = context.getInteger("batchSize", Integer.valueOf(1));
        if (this.batchSize > 1) {
            this.batchArrayList = new ArrayList<Event>(this.batchSize);
        }
    }

    @Override
    public PollableSource.Status process() throws EventDeliveryException {
        try {
            if (this.batchSize <= 1) {
                this.getChannelProcessor().processEvent(EventBuilder.withBody((byte[])String.valueOf(this.sequence++).getBytes()));
            } else {
                this.batchArrayList.clear();
                for (int i = 0; i < this.batchSize; ++i) {
                    this.batchArrayList.add(i, EventBuilder.withBody((byte[])String.valueOf(this.sequence++).getBytes()));
                }
                this.getChannelProcessor().processEventBatch(this.batchArrayList);
            }
            this.counterGroup.incrementAndGet("events.successful");
        }
        catch (ChannelException ex) {
            this.counterGroup.incrementAndGet("events.failed");
        }
        return PollableSource.Status.READY;
    }

    @Override
    public void start() {
        logger.info("Sequence generator source starting");
        super.start();
        logger.debug("Sequence generator source started");
    }

    @Override
    public void stop() {
        logger.info("Sequence generator source stopping");
        super.stop();
        logger.info("Sequence generator source stopped. Metrics:{}", (Object)this.counterGroup);
    }
}

