/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.source;

import com.google.common.base.Preconditions;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.flume.Context;
import org.apache.flume.CounterGroup;
import org.apache.flume.Event;
import org.apache.flume.EventDrivenSource;
import org.apache.flume.channel.ChannelProcessor;
import org.apache.flume.conf.Configurable;
import org.apache.flume.event.EventBuilder;
import org.apache.flume.source.AbstractSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecSource
extends AbstractSource
implements EventDrivenSource,
Configurable {
    private static final Logger logger = LoggerFactory.getLogger(ExecSource.class);
    private String command;
    private CounterGroup counterGroup;
    private ExecutorService executor;
    private Future<?> runnerFuture;
    private long restartThrottle;
    private boolean restart;
    private boolean logStderr;
    private Integer bufferCount;
    private ExecRunnable runner;

    @Override
    public void start() {
        logger.info("Exec source starting with command:{}", (Object)this.command);
        this.executor = Executors.newSingleThreadExecutor();
        this.counterGroup = new CounterGroup();
        this.runner = new ExecRunnable(this.command, this.getChannelProcessor(), this.counterGroup, this.restart, this.restartThrottle, this.logStderr, this.bufferCount);
        this.runnerFuture = this.executor.submit(this.runner);
        super.start();
        logger.debug("Exec source started");
    }

    @Override
    public void stop() {
        logger.info("Stopping exec source with command:{}", (Object)this.command);
        if (this.runner != null) {
            this.runner.setRestart(false);
            this.runner.kill();
        }
        if (this.runnerFuture != null) {
            logger.debug("Stopping exec runner");
            this.runnerFuture.cancel(true);
            logger.debug("Exec runner stopped");
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            logger.debug("Waiting for exec executor service to stop");
            try {
                this.executor.awaitTermination(500L, TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException e) {
                logger.debug("Interrupted while waiting for exec executor service to stop. Just exiting.");
                Thread.currentThread().interrupt();
            }
        }
        super.stop();
        logger.debug("Exec source with command:{} stopped. Metrics:{}", (Object)this.command, (Object)this.counterGroup);
    }

    @Override
    public void configure(Context context) {
        this.command = context.getString("command");
        Preconditions.checkState((this.command != null ? 1 : 0) != 0, (Object)"The parameter command must be specified");
        this.restartThrottle = context.getLong("restartThrottle", Long.valueOf(10000L));
        this.restart = context.getBoolean("restart", Boolean.valueOf(false));
        this.logStderr = context.getBoolean("logStdErr", Boolean.valueOf(false));
        this.bufferCount = context.getInteger("batchSize", Integer.valueOf(20));
    }

    private static class StderrReader
    extends Thread {
        private BufferedReader input;
        private boolean logStderr;

        protected StderrReader(BufferedReader input, boolean logStderr) {
            this.input = input;
            this.logStderr = logStderr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                int i = 0;
                String line = null;
                while ((line = this.input.readLine()) != null) {
                    if (!this.logStderr) continue;
                    logger.info("StderrLogger[{}] = '{}'", (Object)(++i), (Object)line);
                }
            }
            catch (IOException e) {
                logger.info("StderrLogger exiting", (Throwable)e);
            }
            finally {
                try {
                    if (this.input != null) {
                        this.input.close();
                    }
                }
                catch (IOException ex) {
                    logger.error("Failed to close stderr reader for exec source", (Throwable)ex);
                }
            }
        }
    }

    private static class ExecRunnable
    implements Runnable {
        private String command;
        private ChannelProcessor channelProcessor;
        private CounterGroup counterGroup;
        private volatile boolean restart;
        private long restartThrottle;
        private int bufferCount;
        private boolean logStderr;
        private Process process = null;

        public ExecRunnable(String command, ChannelProcessor channelProcessor, CounterGroup counterGroup, boolean restart, long restartThrottle, boolean logStderr, int bufferCount) {
            this.command = command;
            this.channelProcessor = channelProcessor;
            this.counterGroup = counterGroup;
            this.restartThrottle = restartThrottle;
            this.bufferCount = bufferCount;
            this.restart = restart;
            this.logStderr = logStderr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            do {
                String exitCode = "unknown";
                BufferedReader reader = null;
                try {
                    String[] commandArgs = this.command.split("\\s+");
                    this.process = new ProcessBuilder(commandArgs).start();
                    reader = new BufferedReader(new InputStreamReader(this.process.getInputStream()));
                    StderrReader stderrReader = new StderrReader(new BufferedReader(new InputStreamReader(this.process.getErrorStream())), this.logStderr);
                    stderrReader.setName("StderrReader-[" + this.command + "]");
                    stderrReader.setDaemon(true);
                    stderrReader.start();
                    String line = null;
                    ArrayList<Event> eventList = new ArrayList<Event>();
                    while ((line = reader.readLine()) != null) {
                        this.counterGroup.incrementAndGet("exec.lines.read");
                        eventList.add(EventBuilder.withBody((byte[])line.getBytes()));
                        if (eventList.size() < this.bufferCount) continue;
                        this.channelProcessor.processEventBatch(eventList);
                        eventList.clear();
                    }
                    if (!eventList.isEmpty()) {
                        this.channelProcessor.processEventBatch(eventList);
                    }
                }
                catch (Exception e) {
                    logger.error("Failed while running command: " + this.command, (Throwable)e);
                    if (e instanceof InterruptedException) {
                        Thread.currentThread().interrupt();
                    }
                }
                finally {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (IOException ex) {
                            logger.error("Failed to close reader for exec source", (Throwable)ex);
                        }
                    }
                    exitCode = String.valueOf(this.kill());
                }
                if (this.restart) {
                    logger.info("Restarting in {}ms, exit code {}", (Object)this.restartThrottle, (Object)exitCode);
                    try {
                        Thread.sleep(this.restartThrottle);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                    continue;
                }
                logger.info("Command [" + this.command + "] exited with " + exitCode);
            } while (this.restart);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int kill() {
            if (this.process != null) {
                Process process = this.process;
                synchronized (process) {
                    this.process.destroy();
                    try {
                        return this.process.waitFor();
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                return Integer.MIN_VALUE;
            }
            return -1073741824;
        }

        public void setRestart(boolean restart) {
            this.restart = restart;
        }
    }
}

