/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.sink;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import org.apache.flume.Channel;
import org.apache.flume.ChannelException;
import org.apache.flume.Context;
import org.apache.flume.Event;
import org.apache.flume.EventDeliveryException;
import org.apache.flume.FlumeException;
import org.apache.flume.Sink;
import org.apache.flume.Transaction;
import org.apache.flume.api.RpcClient;
import org.apache.flume.api.RpcClientFactory;
import org.apache.flume.conf.Configurable;
import org.apache.flume.instrumentation.SinkCounter;
import org.apache.flume.sink.AbstractSink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroSink
extends AbstractSink
implements Configurable {
    private static final Logger logger = LoggerFactory.getLogger(AvroSink.class);
    private String hostname;
    private Integer port;
    private RpcClient client;
    private Properties clientProps;
    private SinkCounter sinkCounter;

    @Override
    public void configure(Context context) {
        Long requestTimeout;
        Long connectTimeout;
        this.clientProps = new Properties();
        this.hostname = context.getString("hostname");
        this.port = context.getInteger("port");
        Preconditions.checkState((this.hostname != null ? 1 : 0) != 0, (Object)"No hostname specified");
        Preconditions.checkState((this.port != null ? 1 : 0) != 0, (Object)"No port specified");
        this.clientProps.setProperty("hosts", "h1");
        this.clientProps.setProperty("hosts.h1", this.hostname + ":" + this.port);
        Integer batchSize = context.getInteger("batch-size");
        if (batchSize != null) {
            this.clientProps.setProperty("batch-size", String.valueOf(batchSize));
        }
        if ((connectTimeout = context.getLong("connect-timeout")) != null) {
            this.clientProps.setProperty("connect-timeout", String.valueOf(connectTimeout));
        }
        if ((requestTimeout = context.getLong("request-timeout")) != null) {
            this.clientProps.setProperty("request-timeout", String.valueOf(requestTimeout));
        }
        if (this.sinkCounter == null) {
            this.sinkCounter = new SinkCounter(this.getName());
        }
    }

    private void createConnection() throws FlumeException {
        if (this.client == null) {
            logger.info("Avro sink {}: Building RpcClient with hostname: {}, port: {}", new Object[]{this.getName(), this.hostname, this.port});
            try {
                this.client = RpcClientFactory.getInstance((Properties)this.clientProps);
                this.sinkCounter.incrementConnectionCreatedCount();
            }
            catch (Exception ex) {
                this.sinkCounter.incrementConnectionFailedCount();
                if (ex instanceof FlumeException) {
                    throw (FlumeException)((Object)ex);
                }
                throw new FlumeException((Throwable)ex);
            }
            logger.debug("Avro sink {}: Created RpcClient: {}", (Object)this.getName(), (Object)this.client);
        }
    }

    private void destroyConnection() {
        if (this.client != null) {
            logger.debug("Avro sink {} closing avro client: {}", (Object)this.getName(), (Object)this.client);
            try {
                this.client.close();
                this.sinkCounter.incrementConnectionClosedCount();
            }
            catch (FlumeException e) {
                this.sinkCounter.incrementConnectionFailedCount();
                logger.error("Avro sink " + this.getName() + ": Attempt to close avro " + "client failed. Exception follows.", (Throwable)e);
            }
        }
        this.client = null;
    }

    private void verifyConnection() throws FlumeException {
        if (this.client == null) {
            this.createConnection();
        } else if (!this.client.isActive()) {
            this.destroyConnection();
            this.createConnection();
        }
    }

    @Override
    public void start() {
        logger.info("Starting {}...", (Object)this);
        this.sinkCounter.start();
        try {
            this.createConnection();
        }
        catch (FlumeException e) {
            logger.warn("Unable to create avro client using hostname: " + this.hostname + ", port: " + this.port, (Throwable)e);
            this.destroyConnection();
        }
        super.start();
        logger.info("Avro sink {} started.", (Object)this.getName());
    }

    @Override
    public void stop() {
        logger.info("Avro sink {} stopping...", (Object)this.getName());
        this.destroyConnection();
        this.sinkCounter.stop();
        super.stop();
        logger.info("Avro sink {} stopped. Metrics: {}", (Object)this.getName(), (Object)this.sinkCounter);
    }

    @Override
    public String toString() {
        return "AvroSink " + this.getName() + " { host: " + this.hostname + ", port: " + this.port + " }";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Sink.Status process() throws EventDeliveryException {
        Sink.Status status;
        block12: {
            status = Sink.Status.READY;
            Channel channel = this.getChannel();
            Transaction transaction = channel.getTransaction();
            try {
                Event event;
                transaction.begin();
                this.verifyConnection();
                LinkedList batch = Lists.newLinkedList();
                for (int i = 0; i < this.client.getBatchSize() && (event = channel.take()) != null; ++i) {
                    batch.add(event);
                }
                int size = batch.size();
                int batchSize = this.client.getBatchSize();
                if (size == 0) {
                    this.sinkCounter.incrementBatchEmptyCount();
                    status = Sink.Status.BACKOFF;
                } else {
                    if (size < batchSize) {
                        this.sinkCounter.incrementBatchUnderflowCount();
                    } else {
                        this.sinkCounter.incrementBatchCompleteCount();
                    }
                    this.sinkCounter.addToEventDrainAttemptCount(size);
                    this.client.appendBatch((List)batch);
                }
                transaction.commit();
                this.sinkCounter.addToEventDrainSuccessCount(size);
            }
            catch (Throwable t) {
                transaction.rollback();
                if (t instanceof Error) {
                    throw (Error)t;
                }
                if (t instanceof ChannelException) {
                    logger.error("Avro Sink " + this.getName() + ": Unable to get event from" + " channel " + channel.getName() + ". Exception follows.", t);
                    status = Sink.Status.BACKOFF;
                    break block12;
                }
                this.destroyConnection();
                throw new EventDeliveryException("Failed to send events", t);
            }
            finally {
                transaction.close();
            }
        }
        return status;
    }
}

