/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.instrumentation;

import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MonitoredCounterGroup {
    private static final Logger LOG = LoggerFactory.getLogger(MonitoredCounterGroup.class);
    private final Type type;
    private final String name;
    private final Map<String, AtomicLong> counterMap;
    private AtomicLong startTime;
    private AtomicLong stopTime;
    private volatile boolean registered = false;

    protected MonitoredCounterGroup(Type type, String name, String ... attrs) {
        this.type = type;
        this.name = name;
        HashMap<String, AtomicLong> counterInitMap = new HashMap<String, AtomicLong>();
        for (String attribute : attrs) {
            counterInitMap.put(attribute, new AtomicLong(0L));
        }
        this.counterMap = Collections.unmodifiableMap(counterInitMap);
        this.startTime = new AtomicLong(0L);
        this.stopTime = new AtomicLong(0L);
    }

    public void start() {
        this.register();
        this.stopTime.set(0L);
        for (String counter : this.counterMap.keySet()) {
            this.counterMap.get(counter).set(0L);
        }
        this.startTime.set(System.currentTimeMillis());
        LOG.info("Component type: " + (Object)((Object)this.type) + ", name: " + this.name + " started");
    }

    void register() {
        if (!this.registered) {
            try {
                ObjectName objName = new ObjectName("org.apache.flume." + this.type.name().toLowerCase() + ":type=" + this.name);
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, objName);
                this.registered = true;
                LOG.info("Monitoried counter group for type: " + (Object)((Object)this.type) + ", name: " + this.name + ", registered successfully.");
            }
            catch (Exception ex) {
                LOG.error("Failed to register monitored counter group for type: " + (Object)((Object)this.type) + ", name: " + this.name, (Throwable)ex);
            }
        }
    }

    public void stop() {
        this.stopTime.set(System.currentTimeMillis());
        LOG.info("Component type: " + (Object)((Object)this.type) + ", name: " + this.name + " stopped");
    }

    public long getStartTime() {
        return this.startTime.get();
    }

    public long getStopTime() {
        return this.stopTime.get();
    }

    public final String toString() {
        StringBuilder sb = new StringBuilder(this.type.name()).append(":");
        sb.append(this.name).append("{");
        boolean first = true;
        Iterator<String> counterIterator = this.counterMap.keySet().iterator();
        while (counterIterator.hasNext()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            String counterName = counterIterator.next();
            sb.append(counterName).append("=").append(this.get(counterName));
        }
        sb.append("}");
        return sb.toString();
    }

    protected long get(String counter) {
        return this.counterMap.get(counter).get();
    }

    protected void set(String counter, long value) {
        this.counterMap.get(counter).set(value);
    }

    protected long addAndGet(String counter, long delta) {
        return this.counterMap.get(counter).addAndGet(delta);
    }

    protected long increment(String counter) {
        return this.counterMap.get(counter).incrementAndGet();
    }

    public String getType() {
        return this.type.name();
    }

    public static enum Type {
        SOURCE,
        CHANNEL_PROCESSOR,
        CHANNEL,
        SINK_PROCESSOR,
        SINK,
        INTERCEPTOR,
        SERIALIZER,
        OTHER;

    }
}

