/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.conf;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.flume.Context;
import org.apache.flume.conf.ComponentConfiguration;
import org.apache.flume.conf.ComponentConfigurationFactory;
import org.apache.flume.conf.ConfigurationException;
import org.apache.flume.conf.FlumeConfigurationError;
import org.apache.flume.conf.FlumeConfigurationErrorType;
import org.apache.flume.conf.channel.ChannelConfiguration;
import org.apache.flume.conf.channel.ChannelType;
import org.apache.flume.conf.sink.SinkConfiguration;
import org.apache.flume.conf.sink.SinkGroupConfiguration;
import org.apache.flume.conf.sink.SinkType;
import org.apache.flume.conf.source.SourceConfiguration;
import org.apache.flume.conf.source.SourceType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FlumeConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(FlumeConfiguration.class);
    private final Map<String, AgentConfiguration> agentConfigMap = new HashMap<String, AgentConfiguration>();
    private final LinkedList<FlumeConfigurationError> errors = new LinkedList();
    public static final String NEWLINE = System.getProperty("line.separator", "\n");
    public static final String INDENTSTEP = "  ";

    public FlumeConfiguration(Properties properties) {
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String value;
            String name = (String)propertyNames.nextElement();
            if (this.addRawProperty(name, value = properties.getProperty(name))) continue;
            logger.warn("Configuration property ignored: " + name + " = " + value);
        }
        this.validateConfiguration();
    }

    public List<FlumeConfigurationError> getConfigurationErrors() {
        return this.errors;
    }

    public AgentConfiguration getConfigurationFor(String hostname) {
        return this.agentConfigMap.get(hostname);
    }

    private void validateConfiguration() {
        Iterator<String> it = this.agentConfigMap.keySet().iterator();
        while (it.hasNext()) {
            String agentName = it.next();
            AgentConfiguration aconf = this.agentConfigMap.get(agentName);
            if (!aconf.isValid()) {
                logger.warn("Agent configuration invalid for agent '" + agentName + "'. It will be removed.");
                this.errors.add(new FlumeConfigurationError(agentName, "", FlumeConfigurationErrorType.AGENT_CONFIGURATION_INVALID, FlumeConfigurationError.ErrorOrWarning.ERROR));
                it.remove();
            }
            logger.debug("Channels:" + aconf.channels + "\n");
            logger.debug("Sinks " + aconf.sinks + "\n");
            logger.debug("Sources " + aconf.sources + "\n");
        }
        logger.info("Post-validation flume configuration contains configuration  for agents: " + this.agentConfigMap.keySet());
    }

    private boolean addRawProperty(String name, String value) {
        if (name == null || value == null) {
            this.errors.add(new FlumeConfigurationError("", "", FlumeConfigurationErrorType.AGENT_NAME_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR));
            return false;
        }
        if (value.trim().length() == 0) {
            this.errors.add(new FlumeConfigurationError(name, "", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
            return false;
        }
        name = name.trim();
        value = value.trim();
        int index = name.indexOf(46);
        if (index == -1) {
            this.errors.add(new FlumeConfigurationError(name, "", FlumeConfigurationErrorType.AGENT_NAME_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR));
            return false;
        }
        String agentName = name.substring(0, index);
        if (agentName.length() == 0) {
            this.errors.add(new FlumeConfigurationError(name, "", FlumeConfigurationErrorType.AGENT_NAME_MISSING, FlumeConfigurationError.ErrorOrWarning.ERROR));
            return false;
        }
        String configKey = name.substring(index + 1);
        if (configKey.length() == 0) {
            this.errors.add(new FlumeConfigurationError(name, "", FlumeConfigurationErrorType.PROPERTY_NAME_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
            return false;
        }
        AgentConfiguration aconf = this.agentConfigMap.get(agentName);
        if (aconf == null) {
            aconf = new AgentConfiguration(agentName, this.errors);
            this.agentConfigMap.put(agentName, aconf);
        }
        return aconf.addProperty(configKey, value);
    }

    public static class ComponentNameAndConfigKey {
        private final String componentName;
        private final String configKey;

        private ComponentNameAndConfigKey(String name, String configKey) {
            this.componentName = name;
            this.configKey = configKey;
        }

        public String getComponentName() {
            return this.componentName;
        }

        public String getConfigKey() {
            return this.configKey;
        }
    }

    public static class AgentConfiguration {
        private final String agentName;
        private String sources;
        private String sinks;
        private String channels;
        private String sinkgroups;
        private final Map<String, ComponentConfiguration> sourceConfigMap;
        private final Map<String, ComponentConfiguration> sinkConfigMap;
        private final Map<String, ComponentConfiguration> channelConfigMap;
        private final Map<String, ComponentConfiguration> sinkgroupConfigMap;
        private Map<String, Context> sourceContextMap;
        private Map<String, Context> sinkContextMap;
        private Map<String, Context> channelContextMap;
        private Map<String, Context> sinkGroupContextMap;
        private Set<String> sinkSet;
        private Set<String> sourceSet;
        private Set<String> channelSet;
        private Set<String> sinkgroupSet;
        private final List<FlumeConfigurationError> errorList;

        private AgentConfiguration(String agentName, List<FlumeConfigurationError> errorList) {
            this.agentName = agentName;
            this.errorList = errorList;
            this.sourceConfigMap = new HashMap<String, ComponentConfiguration>();
            this.sinkConfigMap = new HashMap<String, ComponentConfiguration>();
            this.channelConfigMap = new HashMap<String, ComponentConfiguration>();
            this.sinkgroupConfigMap = new HashMap<String, ComponentConfiguration>();
            this.sourceContextMap = new HashMap<String, Context>();
            this.sinkContextMap = new HashMap<String, Context>();
            this.channelContextMap = new HashMap<String, Context>();
            this.sinkGroupContextMap = new HashMap<String, Context>();
        }

        public Map<String, ComponentConfiguration> getChannelConfigMap() {
            return this.channelConfigMap;
        }

        public Map<String, ComponentConfiguration> getSourceConfigMap() {
            return this.sourceConfigMap;
        }

        public Map<String, ComponentConfiguration> getSinkConfigMap() {
            return this.sinkConfigMap;
        }

        public Map<String, ComponentConfiguration> getSinkGroupConfigMap() {
            return this.sinkgroupConfigMap;
        }

        public Map<String, Context> getSourceContext() {
            return this.sourceContextMap;
        }

        public Map<String, Context> getSinkContext() {
            return this.sinkContextMap;
        }

        public Map<String, Context> getChannelContext() {
            return this.channelContextMap;
        }

        public Set<String> getSinkSet() {
            return this.sinkSet;
        }

        public Set<String> getSourceSet() {
            return this.sourceSet;
        }

        public Set<String> getChannelSet() {
            return this.channelSet;
        }

        public Set<String> getSinkgroupSet() {
            return this.sinkgroupSet;
        }

        private boolean isValid() {
            logger.debug("Starting validation of configuration for agent: " + this.agentName + ", initial-configuration: " + this.getPrevalidationConfig());
            if (this.channels == null || this.channels.trim().length() == 0) {
                logger.warn("Agent configuration for '" + this.agentName + "' does not contain any channels. Marking it as invalid.");
                this.errorList.add(new FlumeConfigurationError(this.agentName, "channels", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            this.channelSet = new HashSet<String>(Arrays.asList(this.channels.split("\\s+")));
            this.channelSet = this.validateChannels(this.channelSet);
            if (this.channelSet.size() == 0) {
                logger.warn("Agent configuration for '" + this.agentName + "' does not contain any valid channels. Marking it as invalid.");
                this.errorList.add(new FlumeConfigurationError(this.agentName, "channels", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            this.sourceSet = this.validateSources(this.channelSet);
            this.sinkSet = this.validateSinks(this.channelSet);
            this.sinkgroupSet = this.validateGroups(this.sinkSet);
            if (this.sourceSet.size() == 0 && this.sinkSet.size() == 0) {
                logger.warn("Agent configuration for '" + this.agentName + "' has no sources or sinks. Will be marked invalid.");
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sources", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sinks", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            this.sources = this.getSpaceDelimitedList(this.sourceSet);
            this.channels = this.getSpaceDelimitedList(this.channelSet);
            this.sinks = this.getSpaceDelimitedList(this.sinkSet);
            this.sinkgroups = this.getSpaceDelimitedList(this.sinkgroupSet);
            logger.debug("Post validation configuration for " + this.agentName + NEWLINE + this.getPostvalidationConfig());
            return true;
        }

        private ChannelType getKnownChannel(String type) {
            ChannelType[] values;
            for (ChannelType value : values = ChannelType.values()) {
                if (value.toString().equalsIgnoreCase(type)) {
                    return value;
                }
                String channel = value.getChannelClassName();
                if (channel == null || !channel.equalsIgnoreCase(type)) continue;
                return value;
            }
            return null;
        }

        private SinkType getKnownSink(String type) {
            SinkType[] values;
            for (SinkType value : values = SinkType.values()) {
                if (value.toString().equalsIgnoreCase(type)) {
                    return value;
                }
                String sink = value.getSinkClassName();
                if (sink == null || !sink.equalsIgnoreCase(type)) continue;
                return value;
            }
            return null;
        }

        private SourceType getKnownSource(String type) {
            SourceType[] values;
            for (SourceType value : values = SourceType.values()) {
                if (value.toString().equalsIgnoreCase(type)) {
                    return value;
                }
                String src = value.getSourceClassName();
                if (src == null || !src.equalsIgnoreCase(type)) continue;
                return value;
            }
            return null;
        }

        private Set<String> validateChannels(Set<String> channelSet) {
            Iterator<String> iter = channelSet.iterator();
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            ChannelConfiguration conf = null;
            while (iter.hasNext()) {
                String channelName = iter.next();
                Context channelContext = this.channelContextMap.get(channelName);
                if (channelContext != null) {
                    ChannelType chType = this.getKnownChannel(channelContext.getString("type"));
                    boolean configSpecified = false;
                    String config = null;
                    if (chType == null) {
                        config = channelContext.getString("config");
                        if (config == null || config.isEmpty()) {
                            config = "OTHER";
                        } else {
                            configSpecified = true;
                        }
                    } else {
                        config = chType.toString().toUpperCase();
                        configSpecified = true;
                    }
                    try {
                        conf = (ChannelConfiguration)ComponentConfigurationFactory.create(channelName, config, ComponentConfiguration.ComponentType.CHANNEL);
                        logger.debug("Created channel " + channelName);
                        if (conf != null) {
                            conf.configure(channelContext);
                        }
                        if (configSpecified && conf.isNotFoundConfigClass() || !configSpecified) {
                            newContextMap.put(channelName, channelContext);
                        } else if (configSpecified) {
                            this.channelConfigMap.put(channelName, conf);
                        }
                        if (conf == null) continue;
                        this.errorList.addAll(conf.getErrors());
                    }
                    catch (ConfigurationException e) {
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        iter.remove();
                        logger.warn("Could not configure channel " + channelName + ". Skipping it");
                    }
                    continue;
                }
                iter.remove();
                this.errorList.add(new FlumeConfigurationError(this.agentName, channelName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
            }
            this.channelContextMap = newContextMap;
            HashSet<String> tempchannelSet = new HashSet<String>();
            tempchannelSet.addAll(this.channelConfigMap.keySet());
            tempchannelSet.addAll(this.channelContextMap.keySet());
            channelSet.retainAll(tempchannelSet);
            return channelSet;
        }

        private Set<String> validateSources(Set<String> channelSet) {
            if (this.sources == null || this.sources.isEmpty()) {
                logger.warn("Agent configuration for '" + this.agentName + "' has no sources.");
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sources", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.WARNING));
                return new HashSet<String>();
            }
            HashSet<String> sourceSet = new HashSet<String>(Arrays.asList(this.sources.split("\\s+")));
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            Iterator iter = sourceSet.iterator();
            SourceConfiguration srcConf = null;
            while (iter.hasNext()) {
                String sourceName = (String)iter.next();
                Context srcContext = this.sourceContextMap.get(sourceName);
                String config = null;
                boolean configSpecified = false;
                if (srcContext != null) {
                    SourceType srcType = this.getKnownSource(srcContext.getString("type"));
                    if (srcType == null) {
                        config = srcContext.getString("config");
                        if (config == null || config.isEmpty()) {
                            config = "OTHER";
                        } else {
                            configSpecified = true;
                        }
                    } else {
                        config = srcType.toString().toUpperCase();
                        configSpecified = true;
                    }
                    try {
                        srcConf = (SourceConfiguration)ComponentConfigurationFactory.create(sourceName, config, ComponentConfiguration.ComponentType.SOURCE);
                        if (srcConf != null) {
                            srcConf.configure(srcContext);
                            HashSet<String> channels = new HashSet<String>();
                            if (srcConf.getChannels() != null) {
                                channels.addAll(srcConf.getChannels());
                            }
                            channels.retainAll(channelSet);
                            if (channels.isEmpty()) {
                                throw new ConfigurationException("No Channels configured for " + sourceName);
                            }
                            srcContext.put("channels", this.getSpaceDelimitedList(channels));
                        }
                        if (configSpecified && srcConf.isNotFoundConfigClass() || !configSpecified) {
                            newContextMap.put(sourceName, srcContext);
                        } else if (configSpecified) {
                            this.sourceConfigMap.put(sourceName, srcConf);
                        }
                        if (srcConf == null) continue;
                        this.errorList.addAll(srcConf.getErrors());
                    }
                    catch (ConfigurationException e) {
                        if (srcConf != null) {
                            this.errorList.addAll(srcConf.getErrors());
                        }
                        iter.remove();
                        logger.warn("Removed " + sourceName + " due to " + e.getMessage());
                    }
                    continue;
                }
                iter.remove();
                this.errorList.add(new FlumeConfigurationError(this.agentName, sourceName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
                logger.warn("Configuration empty for: " + sourceName + ".Removed.");
            }
            this.sourceContextMap = newContextMap;
            HashSet<String> tempsourceSet = new HashSet<String>();
            tempsourceSet.addAll(this.sourceContextMap.keySet());
            tempsourceSet.addAll(this.sourceConfigMap.keySet());
            sourceSet.retainAll(tempsourceSet);
            return sourceSet;
        }

        private Set<String> validateSinks(Set<String> channelSet) {
            HashMap<String, Context> newContextMap = new HashMap<String, Context>();
            ComponentConfiguration sinkConf = null;
            if (this.sinks == null || this.sinks.isEmpty()) {
                logger.warn("Agent configuration for '" + this.agentName + "' has no sinks.");
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sinks", FlumeConfigurationErrorType.PROPERTY_VALUE_NULL, FlumeConfigurationError.ErrorOrWarning.WARNING));
                return new HashSet<String>();
            }
            HashSet<String> sinkSet = new HashSet<String>(Arrays.asList(this.sinks.split("\\s+")));
            Iterator iter = sinkSet.iterator();
            while (iter.hasNext()) {
                String sinkName = (String)iter.next();
                Context sinkContext = this.sinkContextMap.get(sinkName.trim());
                if (sinkContext == null) {
                    iter.remove();
                    logger.warn("no context for sink" + sinkName);
                    this.errorList.add(new FlumeConfigurationError(this.agentName, sinkName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
                    continue;
                }
                String config = null;
                boolean configSpecified = false;
                SinkType sinkType = this.getKnownSink(sinkContext.getString("type"));
                if (sinkType == null) {
                    config = sinkContext.getString("config");
                    if (config == null || config.isEmpty()) {
                        config = "OTHER";
                    } else {
                        configSpecified = true;
                    }
                } else {
                    config = sinkType.toString().toUpperCase();
                    configSpecified = true;
                }
                try {
                    logger.debug("Creating sink: " + sinkName + " using " + config);
                    sinkConf = (SinkConfiguration)ComponentConfigurationFactory.create(sinkName, config, ComponentConfiguration.ComponentType.SINK);
                    if (sinkConf != null) {
                        ((SinkConfiguration)sinkConf).configure(sinkContext);
                    }
                    if (!channelSet.contains(((SinkConfiguration)sinkConf).getChannel())) {
                        throw new ConfigurationException("Channel " + ((SinkConfiguration)sinkConf).getChannel() + " not in active set.");
                    }
                    if (configSpecified && sinkConf.isNotFoundConfigClass() || !configSpecified) {
                        newContextMap.put(sinkName, sinkContext);
                    } else if (configSpecified) {
                        this.sinkConfigMap.put(sinkName, sinkConf);
                    }
                    if (sinkConf == null) continue;
                    this.errorList.addAll(sinkConf.getErrors());
                }
                catch (ConfigurationException e) {
                    iter.remove();
                    if (sinkConf != null) {
                        this.errorList.addAll(sinkConf.getErrors());
                    }
                    logger.warn("Configuration for : " + sinkName + " has errors, and will be removed: ", (Throwable)((Object)e));
                }
            }
            this.sinkContextMap = newContextMap;
            HashSet<String> tempSinkset = new HashSet<String>();
            tempSinkset.addAll(this.sinkConfigMap.keySet());
            tempSinkset.addAll(this.sinkContextMap.keySet());
            sinkSet.retainAll(tempSinkset);
            return sinkSet;
        }

        private Set<String> validateGroups(Set<String> sinkSet) {
            Set<String> sinkgroupSet = AgentConfiguration.stringToSet(this.sinkgroups, " ");
            HashMap<String, String> usedSinks = new HashMap<String, String>();
            Iterator<String> iter = sinkgroupSet.iterator();
            while (iter.hasNext()) {
                String sinkgroupName = iter.next();
                Context context = this.sinkGroupContextMap.get(sinkgroupName);
                if (context != null) {
                    try {
                        SinkGroupConfiguration conf = (SinkGroupConfiguration)ComponentConfigurationFactory.create(sinkgroupName, "sinkgroup", ComponentConfiguration.ComponentType.SINKGROUP);
                        conf.configure(context);
                        Set<String> groupSinks = this.validGroupSinks(sinkSet, usedSinks, conf);
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        if (groupSinks != null && !groupSinks.isEmpty()) {
                            ArrayList<String> sinkArray = new ArrayList<String>();
                            for (String sink : groupSinks) {
                                sinkArray.add(sink);
                            }
                            conf.setSinks(sinkArray);
                            this.sinkgroupConfigMap.put(sinkgroupName, conf);
                            continue;
                        }
                        this.errorList.add(new FlumeConfigurationError(this.agentName, sinkgroupName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
                        if (conf != null) {
                            this.errorList.addAll(conf.getErrors());
                        }
                        throw new ConfigurationException("No available sinks for sinkgroup: " + sinkgroupName + ". " + "Sinkgroup will be removed");
                    }
                    catch (ConfigurationException e) {
                        iter.remove();
                        this.errorList.add(new FlumeConfigurationError(this.agentName, sinkgroupName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
                        logger.warn("Configuration error for: " + sinkgroupName + ".Removed.");
                        continue;
                    }
                }
                iter.remove();
                this.errorList.add(new FlumeConfigurationError(this.agentName, sinkgroupName, FlumeConfigurationErrorType.CONFIG_ERROR, FlumeConfigurationError.ErrorOrWarning.ERROR));
                logger.warn("Configuration error for: " + sinkgroupName + ".Removed.");
            }
            sinkgroupSet.retainAll(this.sinkgroupConfigMap.keySet());
            return sinkgroupSet;
        }

        private Set<String> validGroupSinks(Set<String> sinkSet, Map<String, String> usedSinks, SinkGroupConfiguration groupConf) {
            Set<String> groupSinks = Collections.synchronizedSet(new HashSet<String>(groupConf.getSinks()));
            if (groupSinks.isEmpty()) {
                return null;
            }
            Iterator<String> sinkIt = groupSinks.iterator();
            while (sinkIt.hasNext()) {
                String curSink = sinkIt.next();
                if (usedSinks.containsKey(curSink)) {
                    logger.warn("Agent configuration for '" + this.agentName + "' sinkgroup '" + groupConf.getComponentName() + "' sink '" + curSink + "' in use by " + "another group: '" + usedSinks.get(curSink) + "', sink not added");
                    this.errorList.add(new FlumeConfigurationError(this.agentName, groupConf.getComponentName(), FlumeConfigurationErrorType.PROPERTY_PART_OF_ANOTHER_GROUP, FlumeConfigurationError.ErrorOrWarning.ERROR));
                    sinkIt.remove();
                    continue;
                }
                if (!sinkSet.contains(curSink)) {
                    logger.warn("Agent configuration for '" + this.agentName + "' sinkgroup '" + groupConf.getComponentName() + "' sink not found: '" + curSink + "',  sink not added");
                    this.errorList.add(new FlumeConfigurationError(this.agentName, curSink, FlumeConfigurationErrorType.INVALID_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR));
                    sinkIt.remove();
                    continue;
                }
                usedSinks.put(curSink, groupConf.getComponentName());
            }
            return groupSinks;
        }

        private String getSpaceDelimitedList(Set<String> entries) {
            if (entries.size() == 0) {
                return null;
            }
            StringBuilder sb = new StringBuilder("");
            for (String entry : entries) {
                sb.append(" ").append(entry);
            }
            return sb.toString().trim();
        }

        private static Set<String> stringToSet(String target, String delim) {
            HashSet<String> out = new HashSet<String>();
            if (target == null || target.trim().length() == 0) {
                return out;
            }
            StringTokenizer t = new StringTokenizer(target, delim);
            while (t.hasMoreTokens()) {
                out.add(t.nextToken());
            }
            return out;
        }

        public String getPrevalidationConfig() {
            StringBuilder sb = new StringBuilder("AgentConfiguration[");
            sb.append(this.agentName).append("]").append(NEWLINE).append("SOURCES: ");
            sb.append(this.sourceContextMap).append(NEWLINE).append("CHANNELS: ");
            sb.append(this.channelContextMap).append(NEWLINE).append("SINKS: ");
            sb.append(this.sinkContextMap).append(NEWLINE);
            return sb.toString();
        }

        public String getPostvalidationConfig() {
            StringBuilder sb = new StringBuilder("AgentConfiguration created without Configuration stubs for which only basic syntactical validation was performed[");
            sb.append(this.agentName).append("]").append(NEWLINE);
            if (!(this.sourceContextMap.isEmpty() && this.sinkContextMap.isEmpty() && this.channelContextMap.isEmpty())) {
                if (!this.sourceContextMap.isEmpty()) {
                    sb.append("SOURCES: ").append(this.sourceContextMap).append(NEWLINE);
                }
                if (!this.channelContextMap.isEmpty()) {
                    sb.append("CHANNELS: ").append(this.channelContextMap).append(NEWLINE);
                }
                if (!this.sinkContextMap.isEmpty()) {
                    sb.append("SINKS: ").append(this.sinkContextMap).append(NEWLINE);
                }
            }
            if (!(this.sourceConfigMap.isEmpty() && this.sinkConfigMap.isEmpty() && this.channelConfigMap.isEmpty())) {
                sb.append("AgentConfiguration created with Configuration stubs for which full validation was performed[");
                sb.append(this.agentName).append("]").append(NEWLINE);
                if (!this.sourceConfigMap.isEmpty()) {
                    sb.append("SOURCES: ").append(this.sourceConfigMap).append(NEWLINE);
                }
                if (!this.channelConfigMap.isEmpty()) {
                    sb.append("CHANNELS: ").append(this.channelConfigMap).append(NEWLINE);
                }
                if (!this.sinkConfigMap.isEmpty()) {
                    sb.append("SINKS: ").append(this.sinkConfigMap).append(NEWLINE);
                }
            }
            return sb.toString();
        }

        private boolean addProperty(String key, String value) {
            if (key.equals("sources")) {
                if (this.sources == null) {
                    this.sources = value;
                    return true;
                }
                logger.warn("Duplicate source list specified for agent: " + this.agentName);
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sources", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            if (key.equals("sinks")) {
                if (this.sinks == null) {
                    this.sinks = value;
                    logger.info("Added sinks: " + this.sinks + " Agent: " + this.agentName);
                    return true;
                }
                logger.warn("Duplicate sink list specfied for agent: " + this.agentName);
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sinks", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            if (key.equals("channels")) {
                if (this.channels == null) {
                    this.channels = value;
                    return true;
                }
                logger.warn("Duplicate channel list specified for agent: " + this.agentName);
                this.errorList.add(new FlumeConfigurationError(this.agentName, "channels", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            if (key.equals("sinkgroups")) {
                if (this.sinkgroups == null) {
                    this.sinkgroups = value;
                    return true;
                }
                logger.warn("Duplicate sinkgroup list specfied for agent: " + this.agentName);
                this.errorList.add(new FlumeConfigurationError(this.agentName, "sinkgroups", FlumeConfigurationErrorType.DUPLICATE_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR));
                return false;
            }
            ComponentNameAndConfigKey cnck = this.parseConfigKey(key, "sources.");
            if (cnck != null) {
                String name = cnck.getComponentName();
                Context srcConf = this.sourceContextMap.get(name);
                if (srcConf == null) {
                    srcConf = new Context();
                    this.sourceContextMap.put(name, srcConf);
                }
                srcConf.put(cnck.getConfigKey(), value);
                return true;
            }
            cnck = this.parseConfigKey(key, "channels.");
            if (cnck != null) {
                String name = cnck.getComponentName();
                Context channelConf = this.channelContextMap.get(name);
                if (channelConf == null) {
                    channelConf = new Context();
                    this.channelContextMap.put(name, channelConf);
                }
                channelConf.put(cnck.getConfigKey(), value);
                return true;
            }
            cnck = this.parseConfigKey(key, "sinks.");
            if (cnck != null) {
                String name = cnck.getComponentName().trim();
                logger.info("Processing:" + name);
                Context sinkConf = this.sinkContextMap.get(name);
                if (sinkConf == null) {
                    logger.debug("Created context for " + name + ": " + cnck.getConfigKey());
                    sinkConf = new Context();
                    this.sinkContextMap.put(name, sinkConf);
                }
                sinkConf.put(cnck.getConfigKey(), value);
                return true;
            }
            cnck = this.parseConfigKey(key, "sinkgroups.");
            if (cnck != null) {
                String name = cnck.getComponentName();
                Context groupConf = this.sinkGroupContextMap.get(name);
                if (groupConf == null) {
                    groupConf = new Context();
                    this.sinkGroupContextMap.put(name, groupConf);
                }
                groupConf.put(cnck.getConfigKey(), value);
                return true;
            }
            logger.warn("Invalid property specified: " + key);
            this.errorList.add(new FlumeConfigurationError(this.agentName, key, FlumeConfigurationErrorType.INVALID_PROPERTY, FlumeConfigurationError.ErrorOrWarning.ERROR));
            return false;
        }

        private ComponentNameAndConfigKey parseConfigKey(String key, String prefix) {
            if (!key.startsWith(prefix)) {
                return null;
            }
            int index = key.indexOf(46, prefix.length() + 1);
            if (index == -1) {
                return null;
            }
            String name = key.substring(prefix.length(), index);
            String configKey = key.substring(prefix.length() + name.length() + 1);
            if (name.length() == 0 || configKey.length() == 0) {
                return null;
            }
            return new ComponentNameAndConfigKey(name, configKey);
        }
    }
}

