/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Serialization {
    static final long SIZE_OF_INT = 4L;
    static final int SIZE_OF_LONG = 8;
    static final int VERSION_2 = 2;
    static final int VERSION_3 = 3;
    static final String METADATA_FILENAME = ".meta";
    static final String METADATA_TMP_FILENAME = ".tmp";
    static final String OLD_METADATA_FILENAME = ".meta.old";
    public static final Logger LOG = LoggerFactory.getLogger(Serialization.class);

    private Serialization() {
    }

    static File getMetaDataTempFile(File metaDataFile) {
        String metaDataFileName = metaDataFile.getName() + METADATA_TMP_FILENAME;
        return new File(metaDataFile.getParentFile(), metaDataFileName);
    }

    static File getMetaDataFile(File file) {
        String metaDataFileName = file.getName() + METADATA_FILENAME;
        return new File(file.getParentFile(), metaDataFileName);
    }

    static File getOldMetaDataFile(File file) {
        String oldMetaDataFileName = file.getName() + OLD_METADATA_FILENAME;
        return new File(file.getParentFile(), oldMetaDataFileName);
    }

    static boolean deleteAllFiles(File checkpointDir) {
        File[] files;
        if (!checkpointDir.isDirectory()) {
            return false;
        }
        StringBuilder builder = new StringBuilder("Deleted the following files from the checkpoint directory: ");
        for (File file : files = checkpointDir.listFiles()) {
            if (!FileUtils.deleteQuietly((File)file)) {
                LOG.info(builder.toString());
                LOG.error("Error while attempting to delete: " + file.getName());
                return false;
            }
            builder.append(", ").append(file.getName());
        }
        builder.append(".");
        LOG.info(builder.toString());
        return true;
    }
}

