/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flume.channel.file;

import com.google.common.collect.Maps;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.flume.Event;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;

class FlumeEvent
implements Event,
Writable {
    private Map<String, String> headers;
    private byte[] body;

    private FlumeEvent() {
        this(null, null);
    }

    FlumeEvent(Map<String, String> headers, byte[] body) {
        this.headers = headers;
        this.body = body;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void write(DataOutput out) throws IOException {
        MapWritable map = this.toMapWritable(this.getHeaders());
        map.write(out);
        byte[] body = this.getBody();
        if (body == null) {
            out.writeInt(-1);
        } else {
            out.writeInt(body.length);
            out.write(body);
        }
    }

    public void readFields(DataInput in) throws IOException {
        MapWritable map = new MapWritable();
        map.readFields(in);
        this.setHeaders(this.fromMapWritable(map));
        byte[] body = null;
        int bodyLength = in.readInt();
        if (bodyLength != -1) {
            body = new byte[bodyLength];
            in.readFully(body);
        }
        this.setBody(body);
    }

    private MapWritable toMapWritable(Map<String, String> map) {
        MapWritable result = new MapWritable();
        if (map != null) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                result.put((Writable)new Text(entry.getKey()), (Writable)new Text(entry.getValue()));
            }
        }
        return result;
    }

    private Map<String, String> fromMapWritable(MapWritable map) {
        HashMap result = Maps.newHashMap();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                result.put(((Writable)entry.getKey()).toString(), ((Writable)entry.getValue()).toString());
            }
        }
        return result;
    }

    static FlumeEvent from(DataInput in) throws IOException {
        FlumeEvent event = new FlumeEvent();
        event.readFields(in);
        return event;
    }
}

