/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import net.hydromatic.avatica.ArrayImpl;
import net.hydromatic.avatica.ColumnMetaData;
import net.hydromatic.avatica.Cursor;
import org.apache.drill.common.exceptions.UserException;
import org.apache.drill.exec.exception.SchemaChangeException;
import org.apache.drill.exec.record.BatchSchema;
import org.apache.drill.exec.record.RecordBatchLoader;
import org.apache.drill.exec.rpc.user.QueryDataBatch;
import org.apache.drill.jdbc.impl.AvaticaDrillSqlAccessor;
import org.apache.drill.jdbc.impl.DrillAccessorList;
import org.apache.drill.jdbc.impl.DrillColumnMetaDataList;
import org.apache.drill.jdbc.impl.DrillResultSetImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DrillCursor
implements Cursor {
    private static final Logger logger = LoggerFactory.getLogger(DrillCursor.class);
    private static final String UNKNOWN_NAME_STRING = "";
    private final DrillResultSetImpl resultSet;
    private final RecordBatchLoader currentBatchHolder;
    private final DrillResultSetImpl.ResultsListener resultsListener;
    private final DrillAccessorList accessors = new DrillAccessorList();
    private BatchSchema schema;
    private DrillColumnMetaDataList columnMetaDataList;
    private boolean initialSchemaLoaded = false;
    private boolean afterFirstBatch = false;
    private boolean returnTrueForNextCallToNext = false;
    private boolean afterLastRow = false;
    private int currentRecordNumber = -1;

    DrillCursor(DrillResultSetImpl resultSet) {
        this.resultSet = resultSet;
        this.currentBatchHolder = resultSet.batchLoader;
        this.resultsListener = resultSet.resultsListener;
    }

    DrillResultSetImpl getResultSet() {
        return this.resultSet;
    }

    protected int getCurrentRecordNumber() {
        return this.currentRecordNumber;
    }

    public List<Cursor.Accessor> createAccessors(List<ColumnMetaData> types, Calendar localCalendar, ArrayImpl.Factory factory) {
        this.columnMetaDataList = (DrillColumnMetaDataList)types;
        return this.accessors;
    }

    private void updateColumns() {
        this.accessors.generateAccessors(this, this.currentBatchHolder);
        ArrayList getObjectClasses = new ArrayList();
        for (int ax = 0; ax < this.accessors.size(); ++ax) {
            AvaticaDrillSqlAccessor accessor = this.accessors.get(ax);
            getObjectClasses.add(accessor.getObjectClass());
        }
        this.columnMetaDataList.updateColumnMetaData("DRILL", UNKNOWN_NAME_STRING, UNKNOWN_NAME_STRING, this.schema, getObjectClasses);
        if (this.getResultSet().changeListener != null) {
            this.getResultSet().changeListener.schemaChanged(this.schema);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean nextRowInternally() throws SQLException {
        if (this.currentRecordNumber + 1 < this.currentBatchHolder.getRecordCount()) {
            ++this.currentRecordNumber;
            return true;
        }
        try {
            boolean schemaChanged;
            QueryDataBatch qrb = this.resultsListener.getNext();
            if (this.afterFirstBatch) {
                while (qrb != null && (qrb.getHeader().getRowCount() == 0 || qrb.getData() == null)) {
                    logger.warn("Spurious batch read: {}", (Object)qrb);
                    qrb.release();
                    qrb = this.resultsListener.getNext();
                    if (qrb == null || qrb.getData() != null) continue;
                    qrb.release();
                    return false;
                }
            }
            this.afterFirstBatch = true;
            if (qrb == null) {
                this.currentBatchHolder.clear();
                this.afterLastRow = true;
                return false;
            }
            this.currentRecordNumber = 0;
            try {
                schemaChanged = this.currentBatchHolder.load(qrb.getHeader().getDef(), qrb.getData());
            }
            finally {
                qrb.release();
            }
            this.schema = this.currentBatchHolder.getSchema();
            if (schemaChanged) {
                this.updateColumns();
            }
            if (this.returnTrueForNextCallToNext && this.currentBatchHolder.getRecordCount() == 0) {
                this.returnTrueForNextCallToNext = false;
            }
            return true;
        }
        catch (UserException e) {
            throw new SQLException(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            throw new SQLException("Interrupted.", e);
        }
        catch (SchemaChangeException e) {
            throw new SQLException("Unexpected SchemaChangeException from RecordBatchLoader.load(...)");
        }
        catch (RuntimeException e) {
            throw new SQLException("Unexpected RuntimeException: " + e.toString(), e);
        }
    }

    void loadInitialSchema() throws SQLException {
        if (this.initialSchemaLoaded) {
            throw new IllegalStateException("loadInitialSchema() called a second time");
        }
        assert (!this.afterLastRow) : "afterLastRow already true in loadInitialSchema()";
        assert (!this.afterFirstBatch) : "afterLastRow already true in loadInitialSchema()";
        assert (-1 == this.currentRecordNumber) : "currentRecordNumber not -1 (is " + this.currentRecordNumber + ") in loadInitialSchema()";
        assert (0 == this.currentBatchHolder.getRecordCount()) : "currentBatchHolder.getRecordCount() not 0 (is " + this.currentBatchHolder.getRecordCount() + " in loadInitialSchema()";
        this.returnTrueForNextCallToNext = true;
        this.nextRowInternally();
        this.initialSchemaLoaded = true;
    }

    public boolean next() throws SQLException {
        if (!this.initialSchemaLoaded) {
            throw new IllegalStateException("next() called but loadInitialSchema() was not called");
        }
        assert (this.afterFirstBatch) : "afterFirstBatch still false in next()";
        if (this.afterLastRow) {
            return false;
        }
        if (this.returnTrueForNextCallToNext) {
            this.returnTrueForNextCallToNext = false;
            return true;
        }
        this.accessors.clearLastColumnIndexedInRow();
        return this.nextRowInternally();
    }

    public void close() {
        this.getResultSet().cleanup();
    }

    public boolean wasNull() throws SQLException {
        return this.accessors.wasNull();
    }
}

