/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestJdbcDistQuery
extends JdbcTestBase {
    static final Logger logger = LoggerFactory.getLogger(TestJdbcDistQuery.class);
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)50000);
    private static final String WORKING_PATH;

    private static void nextUntilEnd(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
    }

    @Test
    public void testSimpleQuerySingleFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, R_NAME from dfs_test.`%s/../../sample-data/regionsSF/`", WORKING_PATH));
    }

    @Test
    public void testSimpleQueryMultiFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, R_NAME from dfs_test.`%s/../../sample-data/regionsMF/`", WORKING_PATH));
    }

    @Test
    public void testWhereOverSFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, R_NAME from dfs_test.`%s/../../sample-data/regionsSF/` WHERE R_REGIONKEY = 1", WORKING_PATH));
    }

    @Test
    public void testWhereOverMFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, R_NAME from dfs_test.`%s/../../sample-data/regionsMF/` WHERE R_REGIONKEY = 1", WORKING_PATH));
    }

    @Test
    public void testAggSingleFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsSF/` group by R_REGIONKEY", WORKING_PATH));
    }

    @Test
    public void testAggMultiFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsMF/` group by R_REGIONKEY", WORKING_PATH));
    }

    @Test
    public void testAggOrderByDiffGKeyMultiFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, SUM(cast(R_REGIONKEY AS int)) As S from dfs_test.`%s/../../sample-data/regionsMF/` group by R_REGIONKEY ORDER BY S", WORKING_PATH));
    }

    @Test
    public void testAggOrderBySameGKeyMultiFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, SUM(cast(R_REGIONKEY AS int)) As S from dfs_test.`%s/../../sample-data/regionsMF/` group by R_REGIONKEY ORDER BY R_REGIONKEY", WORKING_PATH));
    }

    @Ignore
    @Test
    public void testJoinSingleFile() throws Exception {
        this.testQuery(String.format("select T1.R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsSF/` as T1 join dfs_test.`%s/../../sample-data/nationsSF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY", WORKING_PATH, WORKING_PATH));
    }

    @Ignore
    @Test
    public void testJoinMultiFile() throws Exception {
        this.testQuery(String.format("select T1.R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsMF/` as T1 join dfs_test.`%s/../../sample-data/nationsMF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY", WORKING_PATH, WORKING_PATH));
    }

    @Ignore
    @Test
    public void testJoinMFileWhere() throws Exception {
        this.testQuery(String.format("select T1.R_REGIONKEY, T1.R_NAME from dfs_test.`%s/../../sample-data/regionsMF/` as T1 join dfs_test.`%s/../../sample-data/nationsMF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY WHERE T1.R_REGIONKEY  = 3 ", WORKING_PATH, WORKING_PATH));
    }

    @Test
    public void testSortSingleFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsSF/` order by R_REGIONKEY", WORKING_PATH));
    }

    @Test
    public void testSortMultiFile() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsMF/` order by R_REGIONKEY", WORKING_PATH));
    }

    @Test
    public void testSortMFileWhere() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY from dfs_test.`%s/../../sample-data/regionsMF/` WHERE R_REGIONKEY = 1 order by R_REGIONKEY ", WORKING_PATH));
    }

    @Ignore
    @Test
    public void testJoinAggSortWhere() throws Exception {
        this.testQuery(String.format("select T1.R_REGIONKEY, COUNT(1) as CNT from dfs_test.`%s/../../sample-data/regionsMF/` as T1 join dfs_test.`%s/../../sample-data/nationsMF/` as T2 on T1.R_REGIONKEY = T2.N_REGIONKEY WHERE T1.R_REGIONKEY  = 3 GROUP BY T1.R_REGIONKEY ORDER BY T1.R_REGIONKEY", WORKING_PATH, WORKING_PATH));
    }

    @Test
    public void testSelectLimit() throws Exception {
        this.testQuery(String.format("select R_REGIONKEY, R_NAME from dfs_test.`%s/../../sample-data/regionsMF/` limit 2", WORKING_PATH));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testQuery(String sql) throws Exception {
        boolean success = false;
        try (Connection c = DriverManager.getConnection("jdbc:drill:zk=local", null);){
            for (int x = 0; x < 1; ++x) {
                int i;
                Stopwatch watch = Stopwatch.createStarted();
                Statement s = c.createStatement();
                ResultSet r = s.executeQuery(sql);
                boolean first = true;
                ResultSetMetaData md = r.getMetaData();
                if (first) {
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        System.out.print(md.getColumnName(i));
                        System.out.print('\t');
                    }
                    System.out.println();
                    first = false;
                }
                while (r.next()) {
                    md = r.getMetaData();
                    for (i = 1; i <= md.getColumnCount(); ++i) {
                        System.out.print(r.getObject(i));
                        System.out.print('\t');
                    }
                    System.out.println();
                }
                System.out.println(String.format("Query completed in %d millis.", watch.elapsed(TimeUnit.MILLISECONDS)));
            }
            System.out.println("\n\n\n");
            success = true;
        }
        finally {
            if (!success) {
                Thread.sleep(2000L);
            }
        }
    }

    @Test
    public void testSchemaForEmptyResultSet() throws Exception {
        String query = "select fullname, occupation, postal_code from cp.`customer.json` where 0 = 1";
        try (Connection c = DriverManager.getConnection("jdbc:drill:zk=local", null);){
            Statement s = c.createStatement();
            ResultSet r = s.executeQuery(query);
            ResultSetMetaData md = r.getMetaData();
            ArrayList columns = Lists.newArrayList();
            for (int i = 1; i <= md.getColumnCount(); ++i) {
                System.out.print(md.getColumnName(i));
                System.out.print('\t');
                columns.add(md.getColumnName(i));
            }
            Object[] expected = new String[]{"fullname", "occupation", "postal_code"};
            Assert.assertEquals((long)3L, (long)md.getColumnCount());
            Assert.assertArrayEquals((Object[])expected, (Object[])columns.toArray());
            TestJdbcDistQuery.nextUntilEnd(r);
        }
    }

    static {
        Driver.load();
        WORKING_PATH = Paths.get("", new String[0]).toAbsolutePath().toString();
    }
}

