/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import org.apache.drill.common.util.TestTools;
import org.apache.drill.jdbc.AlreadyClosedSqlException;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TestRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Drill2769UnsupportedReportsUseSqlExceptionTest
extends JdbcTestBase {
    private static final Logger logger = LoggerFactory.getLogger(Drill2769UnsupportedReportsUseSqlExceptionTest.class);
    @Rule
    public TestRule TIMEOUT = TestTools.getTimeoutRule((int)180000);
    private static Connection connection;
    private static Statement plainStatement;
    private static PreparedStatement preparedStatement;
    private static ResultSet resultSet;
    private static ResultSetMetaData resultSetMetaData;
    private static DatabaseMetaData databaseMetaData;

    @BeforeClass
    public static void setUpObjects() throws Exception {
        connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        plainStatement = connection.createStatement();
        preparedStatement = connection.prepareStatement("VALUES 'PreparedStatement query'");
        try {
            connection.prepareCall("VALUES 'CallableStatement query'");
            Assert.fail((String)"Test seems to be out of date.  Was prepareCall(...) implemented?");
        }
        catch (UnsupportedOperationException | SQLException e) {
            // empty catch block
        }
        try {
            connection.createArrayOf("INTEGER", new Object[0]);
            Assert.fail((String)"Test seems to be out of date.  Were arrays implemented?");
        }
        catch (UnsupportedOperationException | SQLException exception) {
            // empty catch block
        }
        resultSet = plainStatement.executeQuery("VALUES 'plain Statement query'");
        resultSet.next();
        resultSetMetaData = resultSet.getMetaData();
        databaseMetaData = connection.getMetaData();
        Assert.assertFalse((String)"Test setup error", (boolean)connection.isClosed());
        Assert.assertFalse((String)"Test setup error", (boolean)plainStatement.isClosed());
        Assert.assertFalse((String)"Test setup error", (boolean)preparedStatement.isClosed());
        Assert.assertFalse((String)"Test setup error", (boolean)resultSet.isClosed());
        Assert.assertNotNull((String)"Test setup error", (Object)resultSetMetaData);
        Assert.assertNotNull((String)"Test setup error", (Object)databaseMetaData);
    }

    @AfterClass
    public static void tearDownConnection() throws Exception {
        connection.close();
    }

    @Test
    public void testConnectionMethodsThrowRight() {
        NoNonSqlExceptionsChecker<Connection> checker = new NoNonSqlExceptionsChecker<Connection>(Connection.class, connection);
        checker.testMethods();
        if (checker.hadAnyFailures()) {
            System.err.println(checker.getReport());
            Assert.fail((String)("Non-SQLException exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testPlainStatementMethodsThrowRight() {
        PlainStatementChecker checker = new PlainStatementChecker(connection);
        checker.testMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Non-SQLException exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testPreparedStatementMethodsThrowRight() {
        PreparedStatementChecker checker = new PreparedStatementChecker(connection);
        checker.testMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Non-SQLException exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testResultSetMethodsThrowRight() {
        NoNonSqlExceptionsChecker<ResultSet> checker = new NoNonSqlExceptionsChecker<ResultSet>(ResultSet.class, resultSet);
        checker.testMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Non-SQLException exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testResultSetMetaDataMethodsThrowRight() {
        NoNonSqlExceptionsChecker<ResultSetMetaData> checker = new NoNonSqlExceptionsChecker<ResultSetMetaData>(ResultSetMetaData.class, resultSetMetaData);
        checker.testMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Non-SQLException exception error(s): \n" + checker.getReport()));
        }
    }

    @Test
    public void testDatabaseMetaDataMethodsThrowRight() {
        NoNonSqlExceptionsChecker<DatabaseMetaData> checker = new NoNonSqlExceptionsChecker<DatabaseMetaData>(DatabaseMetaData.class, databaseMetaData);
        checker.testMethods();
        if (checker.hadAnyFailures()) {
            Assert.fail((String)("Non-SQLException exception error(s): \n" + checker.getReport()));
        }
    }

    private static class PreparedStatementChecker
    extends NoNonSqlExceptionsChecker<PreparedStatement> {
        private final Connection factoryConnection;

        PreparedStatementChecker(Connection factoryConnection) {
            super(PreparedStatement.class, null);
            this.factoryConnection = factoryConnection;
        }

        @Override
        protected PreparedStatement getJdbcObject() throws SQLException {
            return this.factoryConnection.prepareStatement(null);
        }
    }

    private static class PlainStatementChecker
    extends NoNonSqlExceptionsChecker<Statement> {
        private final Connection factoryConnection;

        PlainStatementChecker(Connection factoryConnection) {
            super(Statement.class, null);
            this.factoryConnection = factoryConnection;
        }

        @Override
        protected Statement getJdbcObject() throws SQLException {
            return this.factoryConnection.createStatement();
        }
    }

    private static class NoNonSqlExceptionsChecker<INTF> {
        private final Class<INTF> jdbcIntf;
        private final INTF jdbcObject;
        private final StringBuilder failureLinesBuf = new StringBuilder();
        private final StringBuilder successLinesBuf = new StringBuilder();

        NoNonSqlExceptionsChecker(Class<INTF> jdbcIntf, INTF jdbcObject) {
            this.jdbcIntf = jdbcIntf;
            this.jdbcObject = jdbcObject;
        }

        protected INTF getJdbcObject() throws SQLException {
            return this.jdbcObject;
        }

        private static Object getDummyValueForType(Class<?> type) {
            Comparable<Boolean> result;
            if (!type.isPrimitive()) {
                result = null;
            } else if (type == Boolean.TYPE) {
                result = false;
            } else if (type == Byte.TYPE) {
                result = (byte)0;
            } else if (type == Short.TYPE) {
                result = (short)0;
            } else if (type == Integer.TYPE) {
                result = 0;
            } else if (type == Long.TYPE) {
                result = 0L;
            } else if (type == Float.TYPE) {
                result = Float.valueOf(0.0f);
            } else if (type == Double.TYPE) {
                result = 0.0;
            } else {
                Assert.fail((String)("Test needs to be updated to handle type " + type));
                result = null;
            }
            return result;
        }

        private String makeLabel(Method method) {
            String methodLabel = this.jdbcIntf.getSimpleName() + "." + method.getName() + "(";
            boolean first = true;
            for (Class<?> paramType : method.getParameterTypes()) {
                if (!first) {
                    methodLabel = methodLabel + ", ";
                }
                first = false;
                methodLabel = methodLabel + paramType.getSimpleName();
            }
            methodLabel = methodLabel + ")";
            return methodLabel;
        }

        private Object[] makeArgs(Method method) {
            ArrayList<Object> argsList = new ArrayList<Object>();
            for (Class<?> paramType : method.getParameterTypes()) {
                argsList.add(NoNonSqlExceptionsChecker.getDummyValueForType(paramType));
            }
            Object[] argsArray = argsList.toArray();
            return argsArray;
        }

        private void testOneMethod(Method method) {
            String methodLabel = this.makeLabel(method);
            try {
                INTF jdbcObject;
                try {
                    jdbcObject = this.getJdbcObject();
                }
                catch (SQLException e) {
                    Assert.fail((String)("Unexpected exception: " + e + " from getJdbcObject()"));
                    throw new RuntimeException("DUMMY; so compiler know block throws");
                }
                method.invoke(jdbcObject, this.makeArgs(method));
                String resultLine = "- " + methodLabel + " didn't throw\n";
                this.successLinesBuf.append(resultLine);
            }
            catch (InvocationTargetException wrapperEx) {
                Throwable cause = wrapperEx.getCause();
                String resultLine = "- " + methodLabel + " threw <" + cause + ">\n";
                if (SQLException.class.isAssignableFrom(cause.getClass()) && !AlreadyClosedSqlException.class.isAssignableFrom(cause.getClass())) {
                    this.successLinesBuf.append(resultLine);
                } else if (NullPointerException.class == cause.getClass() && (method.getName().equals("isWrapperFor") || method.getName().equals("unwrap"))) {
                    this.successLinesBuf.append(resultLine);
                } else {
                    String badResultLine = "- " + methodLabel + " threw <" + cause + "> instead" + " of a " + SQLException.class.getSimpleName() + "\n";
                    logger.trace("Failure: " + resultLine);
                    this.failureLinesBuf.append(badResultLine);
                }
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                Assert.fail((String)("Unexpected exception: " + e + ", cause = " + e.getCause() + "  from " + method));
            }
        }

        public void testMethods() {
            for (Method method : this.jdbcIntf.getMethods()) {
                String methodLabel = this.makeLabel(method);
                if ("close".equals(method.getName())) {
                    logger.debug("Skipping (because closes): " + methodLabel);
                    continue;
                }
                logger.debug("Testing method " + methodLabel);
                this.testOneMethod(method);
            }
        }

        public boolean hadAnyFailures() {
            return 0 != this.failureLinesBuf.length();
        }

        public String getFailureLines() {
            return this.failureLinesBuf.toString();
        }

        public String getSuccessLines() {
            return this.successLinesBuf.toString();
        }

        public String getReport() {
            String report = "Failures:\n" + this.getFailureLines() + "(Successes:\n" + this.getSuccessLines() + ")";
            return report;
        }
    }
}

