/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Drill2463GetNullsFailedWithAssertionsBugTest
extends JdbcTestBase {
    private static Connection connection;
    private static Statement statement;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        statement = connection.createStatement();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testGetPrimitiveTypeNullAsOwnType() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS INTEGER ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getInt(...) for NULL", (Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testGetPrimitiveTypeNullAsObject() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS INTEGER ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getObject(...) for NULL", (Object)rs.getObject(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testGetNonprimitiveTypeNullAsOwnType() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS VARCHAR ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getString(...) for NULL", (Object)rs.getString(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testGetBooleanNullAsOwnType() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS BOOLEAN ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getBoolean(...) for NULL", (Object)rs.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testGetBooleanNullAsObject() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS BOOLEAN ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getObject(...) for NULL", (Object)rs.getObject(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testGetIntegerNullAsOwnType() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS INTEGER ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getInt(...) for NULL", (Object)rs.getInt(1), (Matcher)CoreMatchers.equalTo((Object)0));
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testGetIntegerNullAsObject() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS INTEGER ) FROM INFORMATION_SCHEMA.CATALOGS");
        Assert.assertTrue((boolean)rs.next());
        Assert.assertThat((String)"getObject(...) for NULL", (Object)rs.getObject(1), (Matcher)CoreMatchers.nullValue());
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

