/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.test;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.drill.jdbc.Driver;
import org.apache.drill.jdbc.JdbcTestBase;
import org.apache.drill.jdbc.test.JdbcAssert;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class Drill2439GetBooleanFailsSayingWrongTypeBugTest
extends JdbcTestBase {
    private static Connection connection;
    private static Statement statement;

    @BeforeClass
    public static void setUpConnection() throws SQLException {
        connection = new Driver().connect("jdbc:drill:zk=local", JdbcAssert.getDefaultProperties());
        statement = connection.createStatement();
    }

    @AfterClass
    public static void tearDownConnection() throws SQLException {
        connection.close();
    }

    @Test
    public void testGetBooleanGetsTrue() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT TRUE FROM INFORMATION_SCHEMA.CATALOGS");
        rs.next();
        Assert.assertThat((String)"getBoolean(...) for TRUE", (Object)rs.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)true));
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testGetBooleanGetsFalse() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT FALSE FROM INFORMATION_SCHEMA.CATALOGS");
        rs.next();
        Assert.assertThat((String)"getBoolean(...) for FALSE", (Object)rs.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)false));
    }

    @Test
    public void testGetBooleanGetsNull() throws Exception {
        ResultSet rs = statement.executeQuery("SELECT CAST( NULL AS BOOLEAN ) FROM INFORMATION_SCHEMA.CATALOGS");
        rs.next();
        Assert.assertThat((String)"getBoolean(...) for BOOLEAN NULL", (Object)rs.getBoolean(1), (Matcher)CoreMatchers.equalTo((Object)false));
        Assert.assertThat((String)"wasNull", (Object)rs.wasNull(), (Matcher)CoreMatchers.equalTo((Object)true));
    }
}

