/*
 * Decompiled with CFR 0.152.
 */
package org.apache.drill.jdbc.impl;

import org.apache.drill.common.types.TypeProtos;
import org.apache.drill.common.types.Types;
import org.apache.drill.exec.vector.accessor.AbstractSqlAccessor;
import org.apache.drill.exec.vector.accessor.InvalidAccessException;
import org.apache.drill.exec.vector.accessor.SqlAccessor;
import org.apache.drill.jdbc.SQLConversionOverflowException;
import org.apache.drill.jdbc.impl.TypeConvertingSqlAccessor;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class TypeConvertingSqlAccessorTest {
    @Test
    public void test_getByte_on_TINYINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(127));
        Assert.assertThat((Object)uut1.getByte(0), (Matcher)CoreMatchers.equalTo((Object)127));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(-128));
        Assert.assertThat((Object)uut2.getByte(0), (Matcher)CoreMatchers.equalTo((Object)-128));
    }

    @Test
    public void test_getByte_on_SMALLINT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(127));
        Assert.assertThat((Object)uut.getByte(0), (Matcher)CoreMatchers.equalTo((Object)127));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getByte_on_SMALLINT_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(128));
        try {
            uut.getByte(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"128"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getByte"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"short"), (Matcher)CoreMatchers.containsString((String)"SMALLINT")));
            throw e;
        }
    }

    @Test
    public void test_getByte_on_INTEGER_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(-128));
        Assert.assertThat((Object)uut.getByte(0), (Matcher)CoreMatchers.equalTo((Object)-128));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getByte_on_INTEGER_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(-129));
        try {
            uut.getByte(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-129"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getByte"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"int"), (Matcher)CoreMatchers.containsString((String)"INTEGER")));
            throw e;
        }
    }

    @Test
    public void test_getByte_on_BIGINT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(-128L));
        Assert.assertThat((Object)uut.getByte(0), (Matcher)CoreMatchers.equalTo((Object)-128));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getByte_on_BIGINT_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(129L));
        try {
            uut.getByte(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"129"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getByte"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"long"), (Matcher)CoreMatchers.containsString((String)"BIGINT")));
            throw e;
        }
    }

    @Test
    public void test_getByte_on_FLOAT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(-128.0f));
        Assert.assertThat((Object)uut.getByte(0), (Matcher)CoreMatchers.equalTo((Object)-128));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getByte_on_FLOAT_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(-130.0f));
        try {
            uut.getByte(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-130"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getByte"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"float"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"REAL"), (Matcher)CoreMatchers.containsString((String)"FLOAT"))));
            throw e;
        }
    }

    @Test
    public void test_getByte_on_DOUBLE_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(127.0));
        Assert.assertThat((Object)uut.getByte(0), (Matcher)CoreMatchers.equalTo((Object)127));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getByte_on_DOUBLE_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(-130.0));
        try {
            uut.getByte(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-130"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getByte"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"double"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"DOUBLE PRECISION"), (Matcher)CoreMatchers.containsString((String)"FLOAT("))));
            throw e;
        }
    }

    @Test
    public void test_getShort_on_TINYINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(127));
        Assert.assertThat((Object)uut1.getShort(0), (Matcher)CoreMatchers.equalTo((Object)127));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(-128));
        Assert.assertThat((Object)uut2.getShort(0), (Matcher)CoreMatchers.equalTo((Object)-128));
    }

    @Test
    public void test_getShort_on_SMALLINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(Short.MAX_VALUE));
        Assert.assertThat((Object)uut1.getShort(0), (Matcher)CoreMatchers.equalTo((Object)Short.MAX_VALUE));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(Short.MIN_VALUE));
        Assert.assertThat((Object)uut2.getShort(0), (Matcher)CoreMatchers.equalTo((Object)Short.MIN_VALUE));
    }

    @Test
    public void test_getShort_on_INTEGER_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(Short.MAX_VALUE));
        Assert.assertThat((Object)uut1.getShort(0), (Matcher)CoreMatchers.equalTo((Object)Short.MAX_VALUE));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(Short.MIN_VALUE));
        Assert.assertThat((Object)uut2.getShort(0), (Matcher)CoreMatchers.equalTo((Object)Short.MIN_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getShort_on_INTEGER_thatOverflows_throws() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(-32769));
        try {
            uut.getShort(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-32769"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getShort"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"int"), (Matcher)CoreMatchers.containsString((String)"INTEGER")));
            throw e;
        }
    }

    @Test
    public void test_getShort_BIGINT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(-32678L));
        Assert.assertThat((Object)uut.getShort(0), (Matcher)CoreMatchers.equalTo((Object)-32678));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getShort_on_BIGINT_thatOverflows_throws() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(65535L));
        try {
            uut.getShort(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"65535"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getShort"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"long"), (Matcher)CoreMatchers.containsString((String)"BIGINT")));
            throw e;
        }
    }

    @Test
    public void test_getShort_on_FLOAT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(-32768.0f));
        Assert.assertThat((Object)uut.getShort(0), (Matcher)CoreMatchers.equalTo((Object)Short.MIN_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getShort_on_FLOAT_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(-32769.0f));
        try {
            uut.getShort(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-32769"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getShort"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"float"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"REAL"), (Matcher)CoreMatchers.containsString((String)"FLOAT"))));
            throw e;
        }
    }

    @Test
    public void test_getShort_on_DOUBLE_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(32767.0));
        Assert.assertThat((Object)uut.getShort(0), (Matcher)CoreMatchers.equalTo((Object)Short.MAX_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getShort_on_DOUBLE_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(32768.0));
        try {
            uut.getShort(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"32768"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getShort"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"double"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"DOUBLE PRECISION"), (Matcher)CoreMatchers.containsString((String)"FLOAT"))));
            throw e;
        }
    }

    @Test
    public void test_getInt_on_TINYINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(127));
        Assert.assertThat((Object)uut1.getInt(0), (Matcher)CoreMatchers.equalTo((Object)127));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(-128));
        Assert.assertThat((Object)uut2.getInt(0), (Matcher)CoreMatchers.equalTo((Object)-128));
    }

    @Test
    public void test_getInt_on_SMALLINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(Short.MAX_VALUE));
        Assert.assertThat((Object)uut1.getInt(0), (Matcher)CoreMatchers.equalTo((Object)Short.MAX_VALUE));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(Short.MIN_VALUE));
        Assert.assertThat((Object)uut2.getInt(0), (Matcher)CoreMatchers.equalTo((Object)Short.MIN_VALUE));
    }

    @Test
    public void test_getInt_on_INTEGER_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(Integer.MAX_VALUE));
        Assert.assertThat((Object)uut1.getInt(0), (Matcher)CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(Integer.MIN_VALUE));
        Assert.assertThat((Object)uut2.getInt(0), (Matcher)CoreMatchers.equalTo((Object)Integer.MIN_VALUE));
    }

    @Test
    public void test_getInt_on_BIGINT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(Integer.MAX_VALUE));
        Assert.assertThat((Object)uut.getInt(0), (Matcher)CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getInt_on_BIGINT_thatOverflows_throws() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(0x80000000L));
        try {
            uut.getInt(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"2147483648"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getInt"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"long"), (Matcher)CoreMatchers.containsString((String)"BIGINT")));
            throw e;
        }
    }

    @Test
    public void test_getInt_on_FLOAT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(1.0E9f));
        Assert.assertThat((Object)uut.getInt(0), (Matcher)CoreMatchers.equalTo((Object)1000000000));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getInt_on_FLOAT_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(1.0E10f));
        try {
            uut.getInt(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"1.0E10"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getInt"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"float"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"REAL"), (Matcher)CoreMatchers.containsString((String)"FLOAT"))));
            throw e;
        }
    }

    @Test
    public void test_getInt_on_DOUBLE_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(-2.147483648E9));
        Assert.assertThat((Object)uut.getInt(0), (Matcher)CoreMatchers.equalTo((Object)Integer.MIN_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getInt_on_DOUBLE_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(-2.147483649E9));
        try {
            uut.getInt(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"-2.147483649E9"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getInt"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"double"), (Matcher)CoreMatchers.containsString((String)"DOUBLE PRECISION")));
            throw e;
        }
    }

    @Test
    public void test_getLong_on_TINYINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(127));
        Assert.assertThat((Object)uut1.getLong(0), (Matcher)CoreMatchers.equalTo((Object)127L));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new TinyIntStubAccessor(-128));
        Assert.assertThat((Object)uut2.getLong(0), (Matcher)CoreMatchers.equalTo((Object)-128L));
    }

    @Test
    public void test_getLong_on_SMALLINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(Short.MAX_VALUE));
        Assert.assertThat((Object)uut1.getLong(0), (Matcher)CoreMatchers.equalTo((Object)32767L));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new SmallIntStubAccessor(Short.MIN_VALUE));
        Assert.assertThat((Object)uut2.getLong(0), (Matcher)CoreMatchers.equalTo((Object)-32768L));
    }

    @Test
    public void test_getLong_on_INTEGER_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(Integer.MAX_VALUE));
        Assert.assertThat((Object)uut1.getLong(0), (Matcher)CoreMatchers.equalTo((Object)Integer.MAX_VALUE));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new IntegerStubAccessor(Integer.MIN_VALUE));
        Assert.assertThat((Object)uut2.getLong(0), (Matcher)CoreMatchers.equalTo((Object)Integer.MIN_VALUE));
    }

    @Test
    public void test_getLong_on_BIGINT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new BigIntStubAccessor(0x80000000L));
        Assert.assertThat((Object)uut.getLong(0), (Matcher)CoreMatchers.equalTo((Object)0x80000000L));
    }

    @Test
    public void test_getLong_on_FLOAT_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(9.223372E18f));
        Assert.assertThat((Object)uut.getLong(0), (Matcher)CoreMatchers.equalTo((Object)Long.MAX_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getLong_on_FLOAT_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(1.5E20f));
        try {
            uut.getLong(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"1.5000"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getLong"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"float"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"REAL"), (Matcher)CoreMatchers.containsString((String)"FLOAT"))));
            throw e;
        }
    }

    @Test
    public void test_getLong_on_DOUBLE_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(9.223372036854776E18));
        Assert.assertThat((Object)uut.getLong(0), (Matcher)CoreMatchers.equalTo((Object)Long.MAX_VALUE));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getLong_on_DOUBLE_thatOverflows_rejectsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(1.0E20));
        try {
            uut.getLong(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"1.0E20"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getLong"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"double"), (Matcher)CoreMatchers.containsString((String)"DOUBLE PRECISION")));
            throw e;
        }
    }

    @Test
    public void test_getFloat_on_FLOAT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(1.23f));
        Assert.assertThat((Object)Float.valueOf(uut1.getFloat(0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1.23f)));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(Float.MAX_VALUE));
        Assert.assertThat((Object)Float.valueOf(uut2.getFloat(0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.MAX_VALUE)));
        TypeConvertingSqlAccessor uut3 = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(Float.MIN_VALUE));
        Assert.assertThat((Object)Float.valueOf(uut3.getFloat(0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.MIN_VALUE)));
    }

    @Test
    public void test_getFloat_on_DOUBLE_thatFits_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(1.125));
        Assert.assertThat((Object)Float.valueOf(uut1.getFloat(0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(1.125f)));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(3.4028234663852886E38));
        Assert.assertThat((Object)Float.valueOf(uut2.getFloat(0)), (Matcher)CoreMatchers.equalTo((Object)Float.valueOf(Float.MAX_VALUE)));
    }

    @Test(expected=SQLConversionOverflowException.class)
    public void test_getFloat_on_DOUBLE_thatOverflows_throws() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(1.0E100));
        try {
            uut.getFloat(0);
        }
        catch (Throwable e) {
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"1.0E100"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.containsString((String)"getFloat"));
            Assert.assertThat((Object)e.getMessage(), (Matcher)CoreMatchers.allOf((Matcher)CoreMatchers.containsString((String)"double"), (Matcher)CoreMatchers.anyOf((Matcher)CoreMatchers.containsString((String)"DOUBLE PRECISION"), (Matcher)CoreMatchers.containsString((String)"FLOAT"))));
            throw e;
        }
    }

    @Test
    public void test_getDouble_on_FLOAT_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(6.02E23f));
        Assert.assertThat((Object)uut1.getDouble(0), (Matcher)CoreMatchers.equalTo((Object)6.02E23f));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(Float.MAX_VALUE));
        Assert.assertThat((Object)uut2.getDouble(0), (Matcher)CoreMatchers.equalTo((Object)3.4028234663852886E38));
        TypeConvertingSqlAccessor uut3 = new TypeConvertingSqlAccessor((SqlAccessor)new FloatStubAccessor(Float.MIN_VALUE));
        Assert.assertThat((Object)uut3.getDouble(0), (Matcher)CoreMatchers.equalTo((Object)1.4E-45f));
    }

    @Test
    public void test_getDouble_on_DOUBLE_getsIt() throws InvalidAccessException {
        TypeConvertingSqlAccessor uut1 = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(-1.0E100));
        Assert.assertThat((Object)uut1.getDouble(0), (Matcher)CoreMatchers.equalTo((Object)-1.0E100));
        TypeConvertingSqlAccessor uut2 = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(Double.MAX_VALUE));
        Assert.assertThat((Object)uut2.getDouble(0), (Matcher)CoreMatchers.equalTo((Object)Double.MAX_VALUE));
        TypeConvertingSqlAccessor uut3 = new TypeConvertingSqlAccessor((SqlAccessor)new DoubleStubAccessor(Double.MIN_VALUE));
        Assert.assertThat((Object)uut3.getDouble(0), (Matcher)CoreMatchers.equalTo((Object)Double.MIN_VALUE));
    }

    private static class DoubleStubAccessor
    extends BaseStubAccessor {
        DoubleStubAccessor(double value) {
            super(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT8), value);
        }

        public double getDouble(int rowOffset) {
            return (Double)this.getValue();
        }
    }

    private static class FloatStubAccessor
    extends BaseStubAccessor {
        FloatStubAccessor(float value) {
            super(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.FLOAT4), Float.valueOf(value));
        }

        public float getFloat(int rowOffset) {
            return ((Float)this.getValue()).floatValue();
        }
    }

    private static class BigIntStubAccessor
    extends BaseStubAccessor {
        BigIntStubAccessor(long value) {
            super(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.BIGINT), value);
        }

        public long getLong(int rowOffset) {
            return (Long)this.getValue();
        }
    }

    private static class IntegerStubAccessor
    extends BaseStubAccessor {
        IntegerStubAccessor(int value) {
            super(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.INT), value);
        }

        public int getInt(int rowOffset) {
            return (Integer)this.getValue();
        }
    }

    private static class SmallIntStubAccessor
    extends BaseStubAccessor {
        SmallIntStubAccessor(short value) {
            super(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.SMALLINT), value);
        }

        public short getShort(int rowOffset) {
            return (Short)this.getValue();
        }
    }

    private static class TinyIntStubAccessor
    extends BaseStubAccessor {
        TinyIntStubAccessor(byte value) {
            super(Types.required((TypeProtos.MinorType)TypeProtos.MinorType.TINYINT), value);
        }

        public byte getByte(int rowOffset) {
            return (Byte)this.getValue();
        }
    }

    private static abstract class BaseStubAccessor
    extends AbstractSqlAccessor
    implements SqlAccessor {
        private final TypeProtos.MajorType type;
        private final Object value;

        BaseStubAccessor(TypeProtos.MajorType type, Object value) {
            this.type = type;
            this.value = value;
        }

        public Class<?> getObjectClass() {
            throw new RuntimeException("Unexpected use of getObjectClass(...)");
        }

        public TypeProtos.MajorType getType() {
            return this.type;
        }

        protected Object getValue() {
            return this.value;
        }

        public boolean isNull(int rowOffset) {
            return false;
        }

        public Object getObject(int rowOffset) throws InvalidAccessException {
            throw new RuntimeException("Unexpected use of getObject(...)");
        }
    }
}

